/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.annotation.support.HandlerMethodInvoker;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.annotation.ServletAnnotationMappingUtils;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class AnnotationMethodHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private WebBindingInitializer webBindingInitializer;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private boolean synchronizeOnSession = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private WebArgumentResolver[] customArgumentResolvers;
    private final Map<Class<?>, ServletHandlerMethodResolver> methodResolverCache = new ConcurrentHashMap();

    public AnnotationMethodHandlerAdapter() {
        super(false);
    }

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, (String)"SessionAttributeStore must not be null");
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public boolean supports(Object handler) {
        return this.getMethodResolver(handler).hasHandlerMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HttpSession session;
        if (handler.getClass().getAnnotation(SessionAttributes.class) != null) {
            this.checkAndPrepare(request, response, 0, true);
        } else {
            this.checkAndPrepare(request, response, true);
        }
        if (this.synchronizeOnSession && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return this.invokeHandlerMethod(request, response, handler);
            }
        }
        return this.invokeHandlerMethod(request, response, handler);
    }

    private ModelAndView invokeHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            ServletHandlerMethodResolver methodResolver = this.getMethodResolver(handler);
            Method handlerMethod = methodResolver.resolveHandlerMethod(request);
            ServletHandlerMethodInvoker methodInvoker = new ServletHandlerMethodInvoker(methodResolver);
            ServletWebRequest webRequest = new ServletWebRequest(request, response);
            ExtendedModelMap implicitModel = new ExtendedModelMap();
            Object result = methodInvoker.invokeHandlerMethod(handlerMethod, handler, (NativeWebRequest)webRequest, implicitModel);
            ModelAndView mav = methodInvoker.getModelAndView(handlerMethod, handler.getClass(), result, implicitModel, webRequest);
            methodInvoker.updateModelAttributes(handler, mav != null ? mav.getModel() : null, implicitModel, (NativeWebRequest)webRequest);
            return mav;
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            return this.handleNoSuchRequestHandlingMethod(ex, request, response);
        }
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    protected ModelAndView handleNoSuchRequestHandlingMethod(NoSuchRequestHandlingMethodException ex, HttpServletRequest request, HttpServletResponse response) throws Exception {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        response.sendError(404);
        return null;
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object target, String objectName) throws Exception {
        return new ServletRequestDataBinder(target, objectName);
    }

    private ServletHandlerMethodResolver getMethodResolver(Object handler) {
        Class handlerClass = ClassUtils.getUserClass((Object)handler);
        ServletHandlerMethodResolver resolver = this.methodResolverCache.get(handlerClass);
        if (resolver == null) {
            resolver = new ServletHandlerMethodResolver(handlerClass);
            this.methodResolverCache.put(handlerClass, resolver);
        }
        return resolver;
    }

    private static class RequestMappingInfo {
        public String[] paths = new String[0];
        public RequestMethod[] methods = new RequestMethod[0];
        public String[] params = new String[0];

        private RequestMappingInfo() {
        }

        public boolean equals(Object obj) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return Arrays.equals(this.paths, other.paths) && Arrays.equals((Object[])this.methods, (Object[])other.methods) && Arrays.equals(this.params, other.params);
        }

        public int hashCode() {
            return Arrays.hashCode(this.paths) * 29 + Arrays.hashCode((Object[])this.methods) * 31 + Arrays.hashCode(this.params);
        }
    }

    private class ServletHandlerMethodInvoker
    extends HandlerMethodInvoker {
        private boolean responseArgumentUsed;

        public ServletHandlerMethodInvoker(HandlerMethodResolver resolver) {
            super(resolver, AnnotationMethodHandlerAdapter.this.webBindingInitializer, AnnotationMethodHandlerAdapter.this.sessionAttributeStore, AnnotationMethodHandlerAdapter.this.parameterNameDiscoverer, AnnotationMethodHandlerAdapter.this.customArgumentResolvers);
            this.responseArgumentUsed = false;
        }

        protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
            throw new MissingServletRequestParameterException(paramName, paramType.getName());
        }

        protected void raiseSessionRequiredException(String message) throws Exception {
            throw new HttpSessionRequiredException(message);
        }

        protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
            return AnnotationMethodHandlerAdapter.this.createBinder((HttpServletRequest)webRequest.getNativeRequest(), target, objectName);
        }

        protected void doBind(NativeWebRequest webRequest, WebDataBinder binder, boolean failOnErrors) throws Exception {
            ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
            servletBinder.bind((ServletRequest)webRequest.getNativeRequest());
            if (failOnErrors) {
                servletBinder.closeNoCatch();
            }
        }

        protected Object resolveStandardArgument(Class parameterType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest();
            HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse();
            if (ServletRequest.class.isAssignableFrom(parameterType)) {
                return request;
            }
            if (ServletResponse.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response;
            }
            if (HttpSession.class.isAssignableFrom(parameterType)) {
                return request.getSession();
            }
            if (Principal.class.isAssignableFrom(parameterType)) {
                return request.getUserPrincipal();
            }
            if (Locale.class.equals((Object)parameterType)) {
                return RequestContextUtils.getLocale(request);
            }
            if (InputStream.class.isAssignableFrom(parameterType)) {
                return request.getInputStream();
            }
            if (Reader.class.isAssignableFrom(parameterType)) {
                return request.getReader();
            }
            if (OutputStream.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getOutputStream();
            }
            if (Writer.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getWriter();
            }
            return super.resolveStandardArgument(parameterType, webRequest);
        }

        public ModelAndView getModelAndView(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel, ServletWebRequest webRequest) {
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Model) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects(((Model)returnValue).asMap());
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof View) {
                return new ModelAndView((View)returnValue).addAllObjects((Map)implicitModel);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map)implicitModel);
            }
            if (returnValue == null) {
                if (this.responseArgumentUsed || webRequest.isNotModified()) {
                    return null;
                }
                return new ModelAndView().addAllObjects((Map)implicitModel);
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                ModelAttribute attr = (ModelAttribute)AnnotationUtils.findAnnotation((Method)handlerMethod, ModelAttribute.class);
                String attrName = attr != null ? attr.value() : "";
                ModelAndView mav = new ModelAndView().addAllObjects((Map)implicitModel);
                if ("".equals(attrName)) {
                    Class resolvedType = GenericTypeResolver.resolveReturnType((Method)handlerMethod, (Class)handlerType);
                    attrName = Conventions.getVariableNameForReturnType((Method)handlerMethod, (Class)resolvedType, (Object)returnValue);
                }
                return mav.addObject(attrName, returnValue);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServletHandlerMethodResolver
    extends HandlerMethodResolver {
        public ServletHandlerMethodResolver(Class<?> handlerType) {
            super(handlerType);
        }

        public Method resolveHandlerMethod(HttpServletRequest request) throws ServletException {
            String lookupPath = AnnotationMethodHandlerAdapter.this.urlPathHelper.getLookupPathForRequest(request);
            LinkedHashMap<RequestMappingInfo, Method> targetHandlerMethods = new LinkedHashMap<RequestMappingInfo, Method>();
            LinkedHashMap<RequestMappingInfo, String> targetPathMatches = new LinkedHashMap<RequestMappingInfo, String>();
            String resolvedMethodName = null;
            for (Method handlerMethod : this.getHandlerMethods()) {
                Method oldMappedMethod;
                RequestMappingInfo mappingInfo = new RequestMappingInfo();
                Object mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)handlerMethod, RequestMapping.class);
                mappingInfo.paths = mapping.value();
                if (!this.hasTypeLevelMapping() || !Arrays.equals((Object[])mapping.method(), (Object[])this.getTypeLevelMapping().method())) {
                    mappingInfo.methods = mapping.method();
                }
                if (!this.hasTypeLevelMapping() || !Arrays.equals(mapping.params(), this.getTypeLevelMapping().params())) {
                    mappingInfo.params = mapping.params();
                }
                boolean match = false;
                if (mappingInfo.paths.length > 0) {
                    for (String mappedPath : mappingInfo.paths) {
                        if (!this.isPathMatch(mappedPath, lookupPath)) continue;
                        if (this.checkParameters(mappingInfo, request)) {
                            match = true;
                            targetPathMatches.put(mappingInfo, mappedPath);
                            continue;
                        }
                        break;
                    }
                } else {
                    match = this.checkParameters(mappingInfo, request);
                    if (match && mappingInfo.methods.length == 0 && mappingInfo.params.length == 0 && resolvedMethodName != null && !resolvedMethodName.equals(handlerMethod.getName())) {
                        match = false;
                    }
                }
                if (!match || (oldMappedMethod = targetHandlerMethods.put(mappingInfo, handlerMethod)) == null || oldMappedMethod == handlerMethod) continue;
                if (AnnotationMethodHandlerAdapter.this.methodNameResolver != null && mappingInfo.paths.length == 0) {
                    if (resolvedMethodName == null) {
                        resolvedMethodName = AnnotationMethodHandlerAdapter.this.methodNameResolver.getHandlerMethodName(request);
                    }
                    if (!resolvedMethodName.equals(oldMappedMethod.getName())) {
                        oldMappedMethod = null;
                    }
                    if (!resolvedMethodName.equals(handlerMethod.getName())) {
                        if (oldMappedMethod != null) {
                            targetHandlerMethods.put(mappingInfo, oldMappedMethod);
                            oldMappedMethod = null;
                        } else {
                            targetHandlerMethods.remove(mappingInfo);
                        }
                    }
                }
                if (oldMappedMethod == null) continue;
                throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + lookupPath + "': {" + oldMappedMethod + ", " + handlerMethod + "}. If you intend to handle the same path in multiple methods, then factor " + "them out into a dedicated handler class with that path mapped at the type level!");
            }
            if (targetHandlerMethods.size() == 1) {
                return (Method)targetHandlerMethods.values().iterator().next();
            }
            if (!targetHandlerMethods.isEmpty()) {
                Object bestMappingMatch = null;
                String bestPathMatch = null;
                for (Object mapping : targetHandlerMethods.keySet()) {
                    String mappedPath = (String)targetPathMatches.get(mapping);
                    if (bestMappingMatch == null) {
                        bestMappingMatch = mapping;
                        bestPathMatch = mappedPath;
                        continue;
                    }
                    if (!this.isBetterPathMatch(mappedPath, bestPathMatch, lookupPath) && (this.isBetterPathMatch(bestPathMatch, mappedPath, lookupPath) || !this.isBetterMethodMatch((RequestMappingInfo)mapping, (RequestMappingInfo)bestMappingMatch) && (this.isBetterMethodMatch((RequestMappingInfo)bestMappingMatch, (RequestMappingInfo)mapping) || !this.isBetterParamMatch((RequestMappingInfo)mapping, (RequestMappingInfo)bestMappingMatch)))) continue;
                    bestMappingMatch = mapping;
                    bestPathMatch = mappedPath;
                }
                return (Method)targetHandlerMethods.get(bestMappingMatch);
            }
            throw new NoSuchRequestHandlingMethodException(lookupPath, request.getMethod(), request.getParameterMap());
        }

        private boolean isPathMatch(String mappedPath, String lookupPath) {
            boolean hasSuffix;
            if (mappedPath.equals(lookupPath) || AnnotationMethodHandlerAdapter.this.pathMatcher.match(mappedPath, lookupPath)) {
                return true;
            }
            boolean bl = hasSuffix = mappedPath.indexOf(46) != -1;
            if (!hasSuffix && AnnotationMethodHandlerAdapter.this.pathMatcher.match(mappedPath + ".*", lookupPath)) {
                return true;
            }
            return !mappedPath.startsWith("/") && (lookupPath.endsWith(mappedPath) || AnnotationMethodHandlerAdapter.this.pathMatcher.match("/**/" + mappedPath, lookupPath) || !hasSuffix && AnnotationMethodHandlerAdapter.this.pathMatcher.match("/**/" + mappedPath + ".*", lookupPath));
        }

        private boolean checkParameters(RequestMappingInfo mapping, HttpServletRequest request) {
            return ServletAnnotationMappingUtils.checkRequestMethod(mapping.methods, request) && ServletAnnotationMappingUtils.checkParameters(mapping.params, request);
        }

        private boolean isBetterPathMatch(String mappedPath, String mappedPathToCompare, String lookupPath) {
            return mappedPath != null && (mappedPathToCompare == null || mappedPath.equals(lookupPath) || mappedPathToCompare.length() < mappedPath.length());
        }

        private boolean isBetterMethodMatch(RequestMappingInfo mapping, RequestMappingInfo mappingToCompare) {
            return mappingToCompare.methods.length == 0 && mapping.methods.length > 0;
        }

        private boolean isBetterParamMatch(RequestMappingInfo mapping, RequestMappingInfo mappingToCompare) {
            return mappingToCompare.params.length < mapping.params.length;
        }
    }
}

