/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.bind.support.SimpleSessionStatus;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartRequest;

public class HandlerMethodInvoker {
    private static final Log logger = LogFactory.getLog(HandlerMethodInvoker.class);
    private final HandlerMethodResolver methodResolver;
    private final WebBindingInitializer bindingInitializer;
    private final SessionAttributeStore sessionAttributeStore;
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final WebArgumentResolver[] customArgumentResolvers;
    private final SimpleSessionStatus sessionStatus = new SimpleSessionStatus();

    public HandlerMethodInvoker(HandlerMethodResolver methodResolver) {
        this(methodResolver, null);
    }

    public HandlerMethodInvoker(HandlerMethodResolver methodResolver, WebBindingInitializer bindingInitializer) {
        this(methodResolver, bindingInitializer, new DefaultSessionAttributeStore(), null, new WebArgumentResolver[0]);
    }

    public HandlerMethodInvoker(HandlerMethodResolver methodResolver, WebBindingInitializer bindingInitializer, SessionAttributeStore sessionAttributeStore, ParameterNameDiscoverer parameterNameDiscoverer, WebArgumentResolver ... customArgumentResolvers) {
        this.methodResolver = methodResolver;
        this.bindingInitializer = bindingInitializer;
        this.sessionAttributeStore = sessionAttributeStore;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        this.customArgumentResolvers = customArgumentResolvers;
    }

    public final Object invokeHandlerMethod(Method handlerMethod, Object handler, NativeWebRequest webRequest, ExtendedModelMap implicitModel) throws Exception {
        boolean debug = logger.isDebugEnabled();
        for (Method attributeMethod : this.methodResolver.getModelAttributeMethods()) {
            Object[] args = this.resolveHandlerArguments(attributeMethod, handler, webRequest, implicitModel);
            if (debug) {
                logger.debug((Object)("Invoking model attribute method: " + attributeMethod));
            }
            Object attrValue = this.doInvokeMethod(attributeMethod, handler, args);
            String attrName = ((ModelAttribute)AnnotationUtils.findAnnotation((Method)attributeMethod, ModelAttribute.class)).value();
            if ("".equals(attrName)) {
                Class resolvedType = GenericTypeResolver.resolveReturnType((Method)attributeMethod, handler.getClass());
                attrName = Conventions.getVariableNameForReturnType((Method)attributeMethod, (Class)resolvedType, (Object)attrValue);
            }
            implicitModel.addAttribute(attrName, attrValue);
        }
        Object[] args = this.resolveHandlerArguments(handlerMethod, handler, webRequest, implicitModel);
        if (debug) {
            logger.debug((Object)("Invoking request handler method: " + handlerMethod));
        }
        return this.doInvokeMethod(handlerMethod, handler, args);
    }

    private Object[] resolveHandlerArguments(Method handlerMethod, Object handler, NativeWebRequest webRequest, ExtendedModelMap implicitModel) throws Exception {
        Class<?>[] paramTypes = handlerMethod.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < args.length; ++i) {
            MethodParameter methodParam = new MethodParameter(handlerMethod, i);
            methodParam.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, handler.getClass());
            String paramName = null;
            boolean paramRequired = false;
            String attrName = null;
            Object[] paramAnns = methodParam.getParameterAnnotations();
            for (int j = 0; j < paramAnns.length; ++j) {
                Object paramAnn = paramAnns[j];
                if (RequestParam.class.isInstance(paramAnn)) {
                    RequestParam requestParam = (RequestParam)paramAnn;
                    paramName = requestParam.value();
                    paramRequired = requestParam.required();
                    break;
                }
                if (!ModelAttribute.class.isInstance(paramAnn)) continue;
                ModelAttribute attr = (ModelAttribute)paramAnn;
                attrName = attr.value();
            }
            if (paramName != null && attrName != null) {
                throw new IllegalStateException("@RequestParam and @ModelAttribute are an exclusive choice -do not specify both on the same parameter: " + handlerMethod);
            }
            Class paramType = methodParam.getParameterType();
            if (paramName == null && attrName == null) {
                Object argValue = this.resolveCommonArgument(methodParam, webRequest);
                if (argValue != WebArgumentResolver.UNRESOLVED) {
                    args[i] = argValue;
                } else if (Model.class.isAssignableFrom(paramType) || Map.class.isAssignableFrom(paramType)) {
                    args[i] = implicitModel;
                } else if (SessionStatus.class.isAssignableFrom(paramType)) {
                    args[i] = this.sessionStatus;
                } else {
                    if (Errors.class.isAssignableFrom(paramType)) {
                        throw new IllegalStateException("Errors/BindingResult argument declared without preceding model attribute. Check your handler method signature!");
                    }
                    if (BeanUtils.isSimpleProperty((Class)paramType)) {
                        paramName = "";
                    } else {
                        attrName = "";
                    }
                }
            }
            if (paramName != null) {
                args[i] = this.resolveRequestParam(paramName, paramRequired, methodParam, webRequest, handler);
                continue;
            }
            if (attrName == null) continue;
            WebDataBinder binder = this.resolveModelAttribute(attrName, methodParam, implicitModel, webRequest, handler);
            if (args.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1])) {
                this.doBind(webRequest, binder, false);
                args[i] = binder.getTarget();
                args[i + 1] = binder.getBindingResult();
                ++i;
            } else {
                this.doBind(webRequest, binder, true);
                args[i] = binder.getTarget();
            }
            implicitModel.putAll(binder.getBindingResult().getModel());
        }
        return args;
    }

    private void initBinder(Object handler, String attrName, WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
        Set<Method> initBinderMethods;
        if (this.bindingInitializer != null) {
            this.bindingInitializer.initBinder(binder, (WebRequest)webRequest);
        }
        if (handler != null && !(initBinderMethods = this.methodResolver.getInitBinderMethods()).isEmpty()) {
            boolean debug = logger.isDebugEnabled();
            for (Method initBinderMethod : initBinderMethods) {
                Object returnValue;
                String[] targetNames = ((InitBinder)AnnotationUtils.findAnnotation((Method)initBinderMethod, InitBinder.class)).value();
                if (targetNames.length != 0 && !Arrays.asList(targetNames).contains(attrName)) continue;
                Object[] initBinderArgs = this.resolveInitBinderArguments(handler, initBinderMethod, binder, webRequest);
                if (debug) {
                    logger.debug((Object)("Invoking init-binder method: " + initBinderMethod));
                }
                if ((returnValue = this.doInvokeMethod(initBinderMethod, handler, initBinderArgs)) == null) continue;
                throw new IllegalStateException("InitBinder methods must not have a return value: " + initBinderMethod);
            }
        }
    }

    private Object[] resolveInitBinderArguments(Object handler, Method initBinderMethod, WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
        Class<?>[] initBinderParams = initBinderMethod.getParameterTypes();
        Object[] initBinderArgs = new Object[initBinderParams.length];
        for (int i = 0; i < initBinderArgs.length; ++i) {
            MethodParameter methodParam = new MethodParameter(initBinderMethod, i);
            methodParam.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, handler.getClass());
            String paramName = null;
            boolean paramRequired = false;
            Object[] paramAnns = methodParam.getParameterAnnotations();
            for (int j = 0; j < paramAnns.length; ++j) {
                Object paramAnn = paramAnns[j];
                if (RequestParam.class.isInstance(paramAnn)) {
                    RequestParam requestParam = (RequestParam)paramAnn;
                    paramName = requestParam.value();
                    paramRequired = requestParam.required();
                    break;
                }
                if (!ModelAttribute.class.isInstance(paramAnn)) continue;
                throw new IllegalStateException("@ModelAttribute is not supported on @InitBinder methods: " + initBinderMethod);
            }
            if (paramName == null) {
                Object argValue = this.resolveCommonArgument(methodParam, webRequest);
                if (argValue != WebArgumentResolver.UNRESOLVED) {
                    initBinderArgs[i] = argValue;
                } else {
                    Class<?> paramType = initBinderParams[i];
                    if (paramType.isInstance((Object)binder)) {
                        initBinderArgs[i] = binder;
                    } else if (BeanUtils.isSimpleProperty(paramType)) {
                        paramName = "";
                    } else {
                        throw new IllegalStateException("Unsupported argument [" + paramType.getName() + "] for @InitBinder method: " + initBinderMethod);
                    }
                }
            }
            if (paramName == null) continue;
            initBinderArgs[i] = this.resolveRequestParam(paramName, paramRequired, methodParam, webRequest, null);
        }
        return initBinderArgs;
    }

    private Object resolveRequestParam(String paramName, boolean paramRequired, MethodParameter methodParam, NativeWebRequest webRequest, Object handlerForInitBinderCall) throws Exception {
        String[] paramValues;
        Class paramType = methodParam.getParameterType();
        if ("".equals(paramName) && (paramName = methodParam.getParameterName()) == null) {
            throw new IllegalStateException("No parameter specified for @RequestParam argument of type [" + paramType.getName() + "], and no parameter name information found in class file either.");
        }
        String[] paramValue = null;
        if (webRequest.getNativeRequest() instanceof MultipartRequest) {
            paramValue = ((MultipartRequest)webRequest.getNativeRequest()).getFile(paramName);
        }
        if (paramValue == null && (paramValues = webRequest.getParameterValues(paramName)) != null) {
            Object object = paramValue = paramValues.length == 1 ? paramValues[0] : paramValues;
        }
        if (paramValue == null) {
            if (paramRequired) {
                this.raiseMissingParameterException(paramName, paramType);
            }
            if (paramType.isPrimitive()) {
                throw new IllegalStateException("Optional " + paramType + " parameter '" + paramName + "' is not present but cannot be translated into a null value due to being declared as a " + "primitive type. Consider declaring it as object wrapper for the corresponding primitive type.");
            }
        }
        WebDataBinder binder = this.createBinder(webRequest, null, paramName);
        this.initBinder(handlerForInitBinderCall, paramName, binder, webRequest);
        return binder.convertIfNecessary(paramValue, paramType, methodParam);
    }

    private WebDataBinder resolveModelAttribute(String attrName, MethodParameter methodParam, ExtendedModelMap implicitModel, NativeWebRequest webRequest, Object handler) throws Exception {
        Object bindObject;
        if ("".equals(attrName)) {
            attrName = Conventions.getVariableNameForParameter((MethodParameter)methodParam);
        }
        Class paramType = methodParam.getParameterType();
        if (!implicitModel.containsKey((Object)attrName) && this.methodResolver.isSessionAttribute(attrName, paramType)) {
            Object sessionAttr = this.sessionAttributeStore.retrieveAttribute((WebRequest)webRequest, attrName);
            if (sessionAttr == null) {
                this.raiseSessionRequiredException("Session attribute '" + attrName + "' required - not found in session");
            }
            implicitModel.addAttribute(attrName, sessionAttr);
        }
        if ((bindObject = implicitModel.get((Object)attrName)) == null) {
            bindObject = BeanUtils.instantiateClass((Class)paramType);
        }
        WebDataBinder binder = this.createBinder(webRequest, bindObject, attrName);
        this.initBinder(handler, attrName, binder, webRequest);
        return binder;
    }

    public final void updateModelAttributes(Object handler, Map mavModel, ExtendedModelMap implicitModel, NativeWebRequest webRequest) throws Exception {
        if (this.methodResolver.hasSessionAttributes() && this.sessionStatus.isComplete()) {
            for (String attrName : this.methodResolver.getActualSessionAttributeNames()) {
                this.sessionAttributeStore.cleanupAttribute((WebRequest)webRequest, attrName);
            }
        }
        Map model = mavModel != null ? mavModel : implicitModel;
        Iterator i$ = new HashSet(model.keySet()).iterator();
        while (i$.hasNext()) {
            String attrName;
            Object attrValue = model.get(attrName = (String)i$.next());
            boolean isSessionAttr = this.methodResolver.isSessionAttribute(attrName, attrValue != null ? attrValue.getClass() : null);
            if (isSessionAttr && !this.sessionStatus.isComplete()) {
                this.sessionAttributeStore.storeAttribute((WebRequest)webRequest, attrName, attrValue);
            }
            if (attrName.startsWith(BindingResult.MODEL_KEY_PREFIX) || !isSessionAttr && !this.isBindingCandidate(attrValue)) continue;
            String bindingResultKey = BindingResult.MODEL_KEY_PREFIX + attrName;
            if (mavModel == null || model.containsKey(bindingResultKey)) continue;
            WebDataBinder binder = this.createBinder(webRequest, attrValue, attrName);
            this.initBinder(handler, attrName, binder, webRequest);
            mavModel.put(bindingResultKey, binder.getBindingResult());
        }
    }

    protected boolean isBindingCandidate(Object value) {
        return value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }

    private Object doInvokeMethod(Method method, Object target, Object[] args) throws Exception {
        ReflectionUtils.makeAccessible((Method)method);
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
            throw new IllegalStateException("Should never get here");
        }
    }

    protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
        throw new IllegalStateException("Missing parameter '" + paramName + "' of type [" + paramType.getName() + "]");
    }

    protected void raiseSessionRequiredException(String message) throws Exception {
        throw new IllegalStateException(message);
    }

    protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
        return new WebRequestDataBinder(target, objectName);
    }

    protected void doBind(NativeWebRequest webRequest, WebDataBinder binder, boolean failOnErrors) throws Exception {
        WebRequestDataBinder requestBinder = (WebRequestDataBinder)binder;
        requestBinder.bind((WebRequest)webRequest);
        if (failOnErrors) {
            requestBinder.closeNoCatch();
        }
    }

    protected Object resolveCommonArgument(MethodParameter methodParameter, NativeWebRequest webRequest) throws Exception {
        if (this.customArgumentResolvers != null) {
            for (WebArgumentResolver argumentResolver : this.customArgumentResolvers) {
                Object value = argumentResolver.resolveArgument(methodParameter, webRequest);
                if (value == WebArgumentResolver.UNRESOLVED) continue;
                return value;
            }
        }
        return this.resolveStandardArgument(methodParameter.getParameterType(), webRequest);
    }

    protected Object resolveStandardArgument(Class parameterType, NativeWebRequest webRequest) throws Exception {
        if (WebRequest.class.isAssignableFrom(parameterType)) {
            return webRequest;
        }
        return WebArgumentResolver.UNRESOLVED;
    }
}

