/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentRegistrar;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.config.AbstractSpecificationExecutor;
import org.springframework.context.config.SpecificationContext;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.config.AnnotationDrivenBeanDefinitionParser;
import org.springframework.web.servlet.config.MvcAnnotationDriven;
import org.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MvcAnnotationDrivenExecutor
extends AbstractSpecificationExecutor<MvcAnnotationDriven> {
    private static final boolean jsr303Present = ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader()) && ClassUtils.isPresent((String)"org.codehaus.jackson.JsonGenerator", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static boolean romePresent = ClassUtils.isPresent((String)"com.sun.syndication.feed.WireFeed", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());

    MvcAnnotationDrivenExecutor() {
    }

    public void doExecute(MvcAnnotationDriven spec, SpecificationContext specContext) {
        ComponentRegistrar registrar = specContext.getRegistrar();
        Object source = spec.source();
        RootBeanDefinition annMappingDef = new RootBeanDefinition(DefaultAnnotationHandlerMapping.class);
        annMappingDef.setSource(source);
        annMappingDef.setRole(2);
        annMappingDef.getPropertyValues().add("order", (Object)0);
        String annMappingName = registrar.registerWithGeneratedName((BeanDefinition)annMappingDef);
        Object conversionService = this.getConversionService(spec, registrar);
        Object validator = this.getValidator(spec, registrar);
        Object messageCodesResolver = this.getMessageCodesResolver(spec, registrar);
        RootBeanDefinition bindingDef = new RootBeanDefinition(ConfigurableWebBindingInitializer.class);
        bindingDef.setSource(source);
        bindingDef.setRole(2);
        bindingDef.getPropertyValues().add("conversionService", conversionService);
        bindingDef.getPropertyValues().add("validator", validator);
        bindingDef.getPropertyValues().add("messageCodesResolver", messageCodesResolver);
        ManagedList<? super Object> messageConverters = this.getMessageConverters(spec, registrar);
        RootBeanDefinition annAdapterDef = new RootBeanDefinition(AnnotationMethodHandlerAdapter.class);
        annAdapterDef.setSource(source);
        annAdapterDef.setRole(2);
        annAdapterDef.getPropertyValues().add("webBindingInitializer", (Object)bindingDef);
        annAdapterDef.getPropertyValues().add("messageConverters", messageConverters);
        if (!spec.argumentResolvers().isEmpty()) {
            annAdapterDef.getPropertyValues().add("customArgumentResolvers", spec.argumentResolvers());
        }
        String annAdapterName = registrar.registerWithGeneratedName((BeanDefinition)annAdapterDef);
        RootBeanDefinition csInterceptorDef = new RootBeanDefinition(ConversionServiceExposingInterceptor.class);
        csInterceptorDef.setSource(source);
        csInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, conversionService);
        RootBeanDefinition mappedCsInterceptorDef = new RootBeanDefinition(MappedInterceptor.class);
        mappedCsInterceptorDef.setSource(source);
        mappedCsInterceptorDef.setRole(2);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, null);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)csInterceptorDef);
        String mappedInterceptorName = registrar.registerWithGeneratedName((BeanDefinition)mappedCsInterceptorDef);
        RootBeanDefinition annExceptionResolver = new RootBeanDefinition(AnnotationMethodHandlerExceptionResolver.class);
        annExceptionResolver.setSource(source);
        annExceptionResolver.setRole(2);
        annExceptionResolver.getPropertyValues().add("messageConverters", messageConverters);
        annExceptionResolver.getPropertyValues().add("order", (Object)0);
        String annExceptionResolverName = registrar.registerWithGeneratedName((BeanDefinition)annExceptionResolver);
        RootBeanDefinition responseStatusExceptionResolver = new RootBeanDefinition(ResponseStatusExceptionResolver.class);
        responseStatusExceptionResolver.setSource(source);
        responseStatusExceptionResolver.setRole(2);
        responseStatusExceptionResolver.getPropertyValues().add("order", (Object)1);
        String responseStatusExceptionResolverName = registrar.registerWithGeneratedName((BeanDefinition)responseStatusExceptionResolver);
        RootBeanDefinition defaultExceptionResolver = new RootBeanDefinition(DefaultHandlerExceptionResolver.class);
        defaultExceptionResolver.setSource(source);
        defaultExceptionResolver.setRole(2);
        defaultExceptionResolver.getPropertyValues().add("order", (Object)2);
        String defaultExceptionResolverName = registrar.registerWithGeneratedName((BeanDefinition)defaultExceptionResolver);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(spec.sourceName(), source);
        compDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)annMappingDef, annMappingName));
        compDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)annAdapterDef, annAdapterName));
        compDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)annExceptionResolver, annExceptionResolverName));
        compDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)responseStatusExceptionResolver, responseStatusExceptionResolverName));
        compDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)defaultExceptionResolver, defaultExceptionResolverName));
        compDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)mappedCsInterceptorDef, mappedInterceptorName));
        registrar.registerComponent((ComponentDefinition)compDefinition);
    }

    private Object getConversionService(MvcAnnotationDriven spec, ComponentRegistrar registrar) {
        if (spec.conversionService() != null) {
            return this.getBeanOrReference(spec.conversionService());
        }
        RootBeanDefinition conversionDef = new RootBeanDefinition(FormattingConversionServiceFactoryBean.class);
        conversionDef.setSource(spec.source());
        conversionDef.setRole(2);
        String conversionName = registrar.registerWithGeneratedName((BeanDefinition)conversionDef);
        registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)conversionDef, conversionName));
        return new RuntimeBeanReference(conversionName);
    }

    private Object getValidator(MvcAnnotationDriven spec, ComponentRegistrar registrar) {
        if (spec.validator() != null) {
            return this.getBeanOrReference(spec.validator());
        }
        if (jsr303Present) {
            RootBeanDefinition validatorDef = new RootBeanDefinition(LocalValidatorFactoryBean.class);
            validatorDef.setSource(spec.source());
            validatorDef.setRole(2);
            String validatorName = registrar.registerWithGeneratedName((BeanDefinition)validatorDef);
            registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)validatorDef, validatorName));
            return new RuntimeBeanReference(validatorName);
        }
        return null;
    }

    private Object getMessageCodesResolver(MvcAnnotationDriven spec, ComponentRegistrar registrar) {
        if (spec.messageCodesResolver() != null) {
            return this.getBeanOrReference(spec.messageCodesResolver());
        }
        return null;
    }

    private ManagedList<? super Object> getMessageConverters(MvcAnnotationDriven spec, ComponentRegistrar registrar) {
        ManagedList messageConverters = new ManagedList();
        Object source = spec.source();
        messageConverters.setSource(source);
        messageConverters.addAll(spec.messageConverters());
        if (spec.shouldRegisterDefaultMessageConverters()) {
            messageConverters.add((Object)this.createConverterBeanDefinition(ByteArrayHttpMessageConverter.class, source));
            RootBeanDefinition stringConverterDef = this.createConverterBeanDefinition(StringHttpMessageConverter.class, source);
            stringConverterDef.getPropertyValues().add("writeAcceptCharset", (Object)false);
            messageConverters.add((Object)stringConverterDef);
            messageConverters.add((Object)this.createConverterBeanDefinition(ResourceHttpMessageConverter.class, source));
            messageConverters.add((Object)this.createConverterBeanDefinition(SourceHttpMessageConverter.class, source));
            messageConverters.add((Object)this.createConverterBeanDefinition(XmlAwareFormHttpMessageConverter.class, source));
            if (jaxb2Present) {
                messageConverters.add((Object)this.createConverterBeanDefinition(Jaxb2RootElementHttpMessageConverter.class, source));
            }
            if (jacksonPresent) {
                messageConverters.add((Object)this.createConverterBeanDefinition(MappingJacksonHttpMessageConverter.class, source));
            }
            if (romePresent) {
                messageConverters.add((Object)this.createConverterBeanDefinition(AtomFeedHttpMessageConverter.class, source));
                messageConverters.add((Object)this.createConverterBeanDefinition(RssChannelHttpMessageConverter.class, source));
            }
        }
        return messageConverters;
    }

    private RootBeanDefinition createConverterBeanDefinition(Class<? extends HttpMessageConverter> converterClass, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(converterClass);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        return beanDefinition;
    }

    private Object getBeanOrReference(Object bean) {
        if (bean != null && bean instanceof String) {
            return new RuntimeBeanReference((String)bean);
        }
        return bean;
    }
}

