/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.parsing.ProblemCollector;
import org.springframework.context.config.AbstractFeatureSpecification;
import org.springframework.context.config.FeatureSpecificationExecutor;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.MvcViewControllersExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MvcViewControllers
extends AbstractFeatureSpecification {
    private static final Class<? extends FeatureSpecificationExecutor> EXECUTOR_TYPE = MvcViewControllersExecutor.class;
    private Map<String, String> mappings = new HashMap<String, String>();

    public MvcViewControllers(String path) {
        this(path, null);
    }

    public MvcViewControllers(String path, String viewName) {
        super(EXECUTOR_TYPE);
        this.mappings.put(path, viewName);
    }

    public MvcViewControllers viewController(String path) {
        return this.viewController(path, null);
    }

    public MvcViewControllers viewController(String path, String viewName) {
        this.mappings.put(path, viewName);
        return this;
    }

    Map<String, String> mappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    protected void doValidate(ProblemCollector problems) {
        if (this.mappings.size() == 0) {
            problems.error("At least one ViewController must be defined");
        }
        for (String path : this.mappings.keySet()) {
            String viewName;
            if (!StringUtils.hasText((String)path)) {
                problems.error("The path attribute in a ViewController is required");
            }
            if ((viewName = this.mappings.get(path)) == null || !viewName.isEmpty()) continue;
            problems.error("The view name in a ViewController may be null but not empty.");
        }
    }
}

