/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HandlerExecutionChain {
    private static final Log logger = LogFactory.getLog(HandlerExecutionChain.class);
    private final Object handler;
    private HandlerInterceptor[] interceptors;
    private List<HandlerInterceptor> interceptorList;
    private int interceptorIndex = -1;

    public HandlerExecutionChain(Object handler) {
        this(handler, null);
    }

    public HandlerExecutionChain(Object handler, HandlerInterceptor[] interceptors) {
        if (handler instanceof HandlerExecutionChain) {
            HandlerExecutionChain originalChain = (HandlerExecutionChain)handler;
            this.handler = originalChain.getHandler();
            this.interceptorList = new ArrayList<HandlerInterceptor>();
            CollectionUtils.mergeArrayIntoCollection((Object)originalChain.getInterceptors(), this.interceptorList);
            CollectionUtils.mergeArrayIntoCollection((Object)interceptors, this.interceptorList);
        } else {
            this.handler = handler;
            this.interceptors = interceptors;
        }
    }

    public Object getHandler() {
        return this.handler;
    }

    public void addInterceptor(HandlerInterceptor interceptor) {
        this.initInterceptorList();
        this.interceptorList.add(interceptor);
    }

    public void addInterceptors(HandlerInterceptor[] interceptors) {
        if (interceptors != null) {
            this.initInterceptorList();
            this.interceptorList.addAll(Arrays.asList(interceptors));
        }
    }

    private void initInterceptorList() {
        if (this.interceptorList == null) {
            this.interceptorList = new ArrayList<HandlerInterceptor>();
        }
        if (this.interceptors != null) {
            this.interceptorList.addAll(Arrays.asList(this.interceptors));
            this.interceptors = null;
        }
    }

    public HandlerInterceptor[] getInterceptors() {
        if (this.interceptors == null && this.interceptorList != null) {
            this.interceptors = this.interceptorList.toArray(new HandlerInterceptor[this.interceptorList.size()]);
        }
        return this.interceptors;
    }

    boolean applyPreHandle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getInterceptors() != null) {
            int i = 0;
            while (i < this.getInterceptors().length) {
                HandlerInterceptor interceptor = this.getInterceptors()[i];
                if (!interceptor.preHandle(request, response, this.handler)) {
                    this.triggerAfterCompletion(request, response, null);
                    return false;
                }
                this.interceptorIndex = i++;
            }
        }
        return true;
    }

    void applyPostHandle(HttpServletRequest request, HttpServletResponse response, ModelAndView mv) throws Exception {
        if (this.getInterceptors() == null) {
            return;
        }
        for (int i = this.getInterceptors().length - 1; i >= 0; --i) {
            HandlerInterceptor interceptor = this.getInterceptors()[i];
            interceptor.postHandle(request, response, this.handler, mv);
        }
    }

    void triggerAfterCompletion(HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        if (this.getInterceptors() == null) {
            return;
        }
        for (int i = this.interceptorIndex; i >= 0; --i) {
            HandlerInterceptor interceptor = this.getInterceptors()[i];
            try {
                interceptor.afterCompletion(request, response, this.handler, ex);
                continue;
            }
            catch (Throwable ex2) {
                logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
            }
        }
    }

    void applyAfterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response) {
        if (this.getInterceptors() == null) {
            return;
        }
        for (int i = this.getInterceptors().length - 1; i >= 0; --i) {
            if (!(this.interceptors[i] instanceof AsyncHandlerInterceptor)) continue;
            try {
                AsyncHandlerInterceptor asyncInterceptor = (AsyncHandlerInterceptor)this.interceptors[i];
                asyncInterceptor.afterConcurrentHandlingStarted(request, response);
                continue;
            }
            catch (Throwable ex) {
                logger.error((Object)("Interceptor [" + this.interceptors[i] + "] failed in afterConcurrentHandlingStarted"), ex);
            }
        }
    }

    public String toString() {
        if (this.handler == null) {
            return "HandlerExecutionChain with no handler";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("HandlerExecutionChain with handler [").append(this.handler).append("]");
        if (!CollectionUtils.isEmpty(this.interceptorList)) {
            sb.append(" and ").append(this.interceptorList.size()).append(" interceptor");
            if (this.interceptorList.size() > 1) {
                sb.append("s");
            }
        }
        return sb.toString();
    }
}

