/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.w3c.dom.Element;

class InterceptorsBeanDefinitionParser
implements BeanDefinitionParser {
    InterceptorsBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compDefinition);
        List interceptors = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{"bean", "ref", "interceptor"});
        for (Element interceptor : interceptors) {
            Object interceptorBean;
            RootBeanDefinition mappedInterceptorDef = new RootBeanDefinition(MappedInterceptor.class);
            mappedInterceptorDef.setSource(parserContext.extractSource((Object)interceptor));
            mappedInterceptorDef.setRole(2);
            String[] includePatterns = null;
            String[] excludePatterns = null;
            if ("interceptor".equals(interceptor.getLocalName())) {
                includePatterns = this.getIncludePatterns(interceptor, "mapping");
                excludePatterns = this.getIncludePatterns(interceptor, "exclude-mapping");
                Element beanElem = (Element)DomUtils.getChildElementsByTagName((Element)interceptor, (String[])new String[]{"bean", "ref"}).get(0);
                interceptorBean = parserContext.getDelegate().parsePropertySubElement(beanElem, null);
            } else {
                interceptorBean = parserContext.getDelegate().parsePropertySubElement(interceptor, null);
            }
            mappedInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)includePatterns);
            mappedInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)excludePatterns);
            mappedInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(2, interceptorBean);
            String beanName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)mappedInterceptorDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)mappedInterceptorDef, beanName));
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private String[] getIncludePatterns(Element interceptor, String elementName) {
        List paths = DomUtils.getChildElementsByTagName((Element)interceptor, (String)elementName);
        String[] patterns = new String[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            patterns[i] = ((Element)paths.get(i)).getAttribute("path");
        }
        return patterns;
    }
}

