/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.FixedContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.accept.ParameterContentNegotiationStrategy;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNegotiationConfigurer {
    private boolean favorPathExtension = true;
    private boolean favorParameter = false;
    private boolean ignoreAcceptHeader = false;
    private Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>();
    private Boolean useJaf;
    private String parameterName;
    private MediaType defaultContentType;

    public ContentNegotiationConfigurer setFavorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
        return this;
    }

    public ContentNegotiationConfigurer addMediaType(String extension, MediaType mediaType) {
        this.mediaTypes.put(extension, mediaType);
        return this;
    }

    public ContentNegotiationConfigurer addMediaTypes(Map<String, MediaType> mediaTypes) {
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                String extension = entry.getKey().toLowerCase(Locale.ENGLISH);
                this.mediaTypes.put(extension, entry.getValue());
            }
        }
        return this;
    }

    public ContentNegotiationConfigurer replaceMediaTypes(Map<String, MediaType> mediaTypes) {
        this.mediaTypes.clear();
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                String extension = entry.getKey().toLowerCase(Locale.ENGLISH);
                this.mediaTypes.put(extension, entry.getValue());
            }
        }
        return this;
    }

    public ContentNegotiationConfigurer setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
        return this;
    }

    public ContentNegotiationConfigurer setFavorParameter(boolean favorParameter) {
        this.favorParameter = favorParameter;
        return this;
    }

    public ContentNegotiationConfigurer setParameterName(String parameterName) {
        this.parameterName = parameterName;
        return this;
    }

    public ContentNegotiationConfigurer setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
        return this;
    }

    public ContentNegotiationConfigurer setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
        return this;
    }

    protected ContentNegotiationManager getContentNegotiationManager() {
        PathExtensionContentNegotiationStrategy strategy;
        ArrayList<Object> strategies = new ArrayList<Object>();
        if (this.favorPathExtension) {
            strategy = new PathExtensionContentNegotiationStrategy(this.mediaTypes);
            if (this.useJaf != null) {
                strategy.setUseJaf(this.useJaf.booleanValue());
            }
            strategies.add(strategy);
        }
        if (this.favorParameter) {
            strategy = new ParameterContentNegotiationStrategy(this.mediaTypes);
            strategy.setParameterName(this.parameterName);
            strategies.add(strategy);
        }
        if (!this.ignoreAcceptHeader) {
            strategies.add(new HeaderContentNegotiationStrategy());
        }
        if (this.defaultContentType != null) {
            strategies.add(new FixedContentNegotiationStrategy(this.defaultContentType));
        }
        ContentNegotiationStrategy[] array = strategies.toArray(new ContentNegotiationStrategy[strategies.size()]);
        return new ContentNegotiationManager(array);
    }
}

