/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.ResourceBundleThemeSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.EscapedErrors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.RequestDataValueProcessor;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriTemplate;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class RequestContext {
    public static final String DEFAULT_THEME_NAME = "theme";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = RequestContext.class.getName() + ".CONTEXT";
    private static final String REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME = "requestDataValueProcessor";
    protected static final boolean jstlPresent = ClassUtils.isPresent((String)"javax.servlet.jsp.jstl.core.Config", (ClassLoader)RequestContext.class.getClassLoader());
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, Object> model;
    private WebApplicationContext webApplicationContext;
    private Locale locale;
    private Theme theme;
    private Boolean defaultHtmlEscape;
    private UrlPathHelper urlPathHelper;
    private RequestDataValueProcessor requestDataValueProcessor;
    private Map<String, Errors> errorsMap;

    public RequestContext(HttpServletRequest request) {
        this.initContext(request, null, null, null);
    }

    public RequestContext(HttpServletRequest request, ServletContext servletContext) {
        this.initContext(request, null, servletContext, null);
    }

    public RequestContext(HttpServletRequest request, Map<String, Object> model) {
        this.initContext(request, null, null, model);
    }

    public RequestContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Map<String, Object> model) {
        this.initContext(request, response, servletContext, model);
    }

    protected RequestContext() {
    }

    protected void initContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Map<String, Object> model) {
        LocaleResolver localeResolver;
        this.request = request;
        this.response = response;
        this.model = model;
        this.webApplicationContext = (WebApplicationContext)request.getAttribute(WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (this.webApplicationContext == null) {
            this.webApplicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request, servletContext);
        }
        this.locale = (localeResolver = RequestContextUtils.getLocaleResolver(request)) != null ? localeResolver.resolveLocale(request) : this.getFallbackLocale();
        this.defaultHtmlEscape = WebUtils.getDefaultHtmlEscape((ServletContext)this.webApplicationContext.getServletContext());
        this.urlPathHelper = new UrlPathHelper();
        if (this.webApplicationContext.containsBean(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME)) {
            this.requestDataValueProcessor = (RequestDataValueProcessor)this.webApplicationContext.getBean(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, RequestDataValueProcessor.class);
        }
    }

    protected Locale getFallbackLocale() {
        Locale locale;
        if (jstlPresent && (locale = JstlLocaleResolver.getJstlLocale(this.getRequest(), this.getServletContext())) != null) {
            return locale;
        }
        return this.getRequest().getLocale();
    }

    protected Theme getFallbackTheme() {
        Theme theme;
        ThemeSource themeSource = RequestContextUtils.getThemeSource(this.getRequest());
        if (themeSource == null) {
            themeSource = new ResourceBundleThemeSource();
        }
        if ((theme = themeSource.getTheme(DEFAULT_THEME_NAME)) == null) {
            throw new IllegalStateException("No theme defined and no fallback theme found");
        }
        return theme;
    }

    protected final HttpServletRequest getRequest() {
        return this.request;
    }

    protected final ServletContext getServletContext() {
        return this.webApplicationContext.getServletContext();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    public final MessageSource getMessageSource() {
        return this.webApplicationContext;
    }

    public final Map<String, Object> getModel() {
        return this.model;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Theme getTheme() {
        if (this.theme == null) {
            this.theme = RequestContextUtils.getTheme(this.request);
            if (this.theme == null) {
                this.theme = this.getFallbackTheme();
            }
        }
        return this.theme;
    }

    public void setDefaultHtmlEscape(boolean defaultHtmlEscape) {
        this.defaultHtmlEscape = defaultHtmlEscape;
    }

    public boolean isDefaultHtmlEscape() {
        return this.defaultHtmlEscape != null && this.defaultHtmlEscape != false;
    }

    public Boolean getDefaultHtmlEscape() {
        return this.defaultHtmlEscape;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public RequestDataValueProcessor getRequestDataValueProcessor() {
        return this.requestDataValueProcessor;
    }

    public String getContextPath() {
        return this.urlPathHelper.getOriginatingContextPath(this.request);
    }

    public String getContextUrl(String relativeUrl) {
        String url = this.getContextPath() + relativeUrl;
        if (this.response != null) {
            url = this.response.encodeURL(url);
        }
        return url;
    }

    public String getContextUrl(String relativeUrl, Map<String, ?> params) {
        String url = this.getContextPath() + relativeUrl;
        UriTemplate template = new UriTemplate(url);
        url = template.expand(params).toASCIIString();
        if (this.response != null) {
            url = this.response.encodeURL(url);
        }
        return url;
    }

    public String getPathToServlet() {
        String path = this.urlPathHelper.getOriginatingContextPath(this.request);
        if (StringUtils.hasText((String)this.urlPathHelper.getPathWithinServletMapping(this.request))) {
            path = path + this.urlPathHelper.getOriginatingServletPath(this.request);
        }
        return path;
    }

    public String getRequestUri() {
        return this.urlPathHelper.getOriginatingRequestUri(this.request);
    }

    public String getQueryString() {
        return this.urlPathHelper.getOriginatingQueryString(this.request);
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        return this.getMessage(code, args, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, List args, String defaultMessage) {
        return this.getMessage(code, args != null ? args.toArray() : null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args, String defaultMessage, boolean htmlEscape) {
        String msg = this.webApplicationContext.getMessage(code, args, defaultMessage, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.getMessage(code, null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.getMessage(code, args, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, List args) throws NoSuchMessageException {
        return this.getMessage(code, args != null ? args.toArray() : null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object[] args, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.webApplicationContext.getMessage(code, args, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.getMessage(resolvable, this.isDefaultHtmlEscape());
    }

    public String getMessage(MessageSourceResolvable resolvable, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.webApplicationContext.getMessage(resolvable, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getThemeMessage(String code, String defaultMessage) {
        return this.getTheme().getMessageSource().getMessage(code, null, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code, Object[] args, String defaultMessage) {
        return this.getTheme().getMessageSource().getMessage(code, args, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code, List args, String defaultMessage) {
        return this.getTheme().getMessageSource().getMessage(code, args != null ? args.toArray() : null, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code) throws NoSuchMessageException {
        return this.getTheme().getMessageSource().getMessage(code, null, this.locale);
    }

    public String getThemeMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.getTheme().getMessageSource().getMessage(code, args, this.locale);
    }

    public String getThemeMessage(String code, List args) throws NoSuchMessageException {
        return this.getTheme().getMessageSource().getMessage(code, args != null ? args.toArray() : null, this.locale);
    }

    public String getThemeMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.getTheme().getMessageSource().getMessage(resolvable, this.locale);
    }

    public Errors getErrors(String name) {
        return this.getErrors(name, this.isDefaultHtmlEscape());
    }

    public Errors getErrors(String name, boolean htmlEscape) {
        if (this.errorsMap == null) {
            this.errorsMap = new HashMap<String, Errors>();
        }
        Errors errors = this.errorsMap.get(name);
        boolean put = false;
        if (errors == null) {
            errors = (Errors)this.getModelObject(BindingResult.MODEL_KEY_PREFIX + name);
            if (errors instanceof BindException) {
                errors = ((BindException)errors).getBindingResult();
            }
            if (errors == null) {
                return null;
            }
            put = true;
        }
        if (htmlEscape && !(errors instanceof EscapedErrors)) {
            errors = new EscapedErrors(errors);
            put = true;
        } else if (!htmlEscape && errors instanceof EscapedErrors) {
            errors = ((EscapedErrors)errors).getSource();
            put = true;
        }
        if (put) {
            this.errorsMap.put(name, errors);
        }
        return errors;
    }

    protected Object getModelObject(String modelName) {
        if (this.model != null) {
            return this.model.get(modelName);
        }
        return this.request.getAttribute(modelName);
    }

    public BindStatus getBindStatus(String path) throws IllegalStateException {
        return new BindStatus(this, path, this.isDefaultHtmlEscape());
    }

    public BindStatus getBindStatus(String path, boolean htmlEscape) throws IllegalStateException {
        return new BindStatus(this, path, htmlEscape);
    }

    private static class JstlLocaleResolver {
        private JstlLocaleResolver() {
        }

        public static Locale getJstlLocale(HttpServletRequest request, ServletContext servletContext) {
            Object localeObject = Config.get((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale");
            if (localeObject == null) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    localeObject = Config.get((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale");
                }
                if (localeObject == null && servletContext != null) {
                    localeObject = Config.get((ServletContext)servletContext, (String)"javax.servlet.jsp.jstl.fmt.locale");
                }
            }
            return localeObject instanceof Locale ? (Locale)localeObject : null;
        }
    }
}

