/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class ServletUriComponentsBuilder
extends UriComponentsBuilder {
    private String servletRequestURI;

    protected ServletUriComponentsBuilder() {
    }

    public static ServletUriComponentsBuilder fromContextPath(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest(request);
        builder.replacePath(request.getContextPath());
        builder.replaceQuery(null);
        return builder;
    }

    public static ServletUriComponentsBuilder fromServletMapping(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromContextPath(request);
        if (StringUtils.hasText((String)new UrlPathHelper().getPathWithinServletMapping(request))) {
            builder.path(request.getServletPath());
        }
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequestUri(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest(request);
        builder.pathFromRequest(request);
        builder.replaceQuery(null);
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequest(HttpServletRequest request) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        String host = request.getServerName();
        String xForwardedHostHeader = request.getHeader("X-Forwarded-Host");
        if (StringUtils.hasText((String)xForwardedHostHeader)) {
            if (StringUtils.countOccurrencesOf((String)xForwardedHostHeader, (String)":") == 1) {
                String[] hostAndPort = StringUtils.split((String)xForwardedHostHeader, (String)":");
                host = hostAndPort[0];
                port = Integer.parseInt(hostAndPort[1]);
            } else {
                host = xForwardedHostHeader;
            }
        }
        ServletUriComponentsBuilder builder = new ServletUriComponentsBuilder();
        builder.scheme(scheme);
        builder.host(host);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            builder.port(port);
        }
        builder.pathFromRequest(request);
        builder.query(request.getQueryString());
        return builder;
    }

    public static ServletUriComponentsBuilder fromCurrentContextPath() {
        return ServletUriComponentsBuilder.fromContextPath(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentServletMapping() {
        return ServletUriComponentsBuilder.fromServletMapping(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequestUri() {
        return ServletUriComponentsBuilder.fromRequestUri(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequest() {
        return ServletUriComponentsBuilder.fromRequest(ServletUriComponentsBuilder.getCurrentRequest());
    }

    protected static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state((requestAttributes != null ? 1 : 0) != 0, (String)"Could not find current request via RequestContextHolder");
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)requestAttributes);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"Could not find current HttpServletRequest");
        return servletRequest;
    }

    private void pathFromRequest(HttpServletRequest request) {
        this.servletRequestURI = request.getRequestURI();
        this.replacePath(request.getRequestURI());
    }

    public String removePathExtension() {
        String extension = null;
        if (this.servletRequestURI != null) {
            String filename = WebUtils.extractFullFilenameFromUrlPath((String)this.servletRequestURI);
            extension = StringUtils.getFilenameExtension((String)filename);
            if (!StringUtils.isEmpty((Object)extension)) {
                int end = this.servletRequestURI.length() - (extension.length() + 1);
                this.replacePath(this.servletRequestURI.substring(0, end));
            }
            this.servletRequestURI = null;
        }
        return extension;
    }
}

