/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.Arrays;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.config.MvcNamespaceUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.w3c.dom.Element;

class ResourcesBeanDefinitionParser
implements BeanDefinitionParser {
    ResourcesBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        String resourceHandlerName = this.registerResourceHandler(parserContext, element, source);
        if (resourceHandlerName == null) {
            return null;
        }
        ManagedMap urlMap = new ManagedMap();
        String resourceRequestPath = element.getAttribute("mapping");
        if (!StringUtils.hasText((String)resourceRequestPath)) {
            parserContext.getReaderContext().error("The 'mapping' attribute is required.", parserContext.extractSource((Object)element));
            return null;
        }
        urlMap.put(resourceRequestPath, resourceHandlerName);
        RuntimeBeanReference pathMatcherRef = MvcNamespaceUtils.registerPathMatcher(null, parserContext, source);
        RuntimeBeanReference pathHelperRef = MvcNamespaceUtils.registerUrlPathHelper(null, parserContext, source);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        handlerMappingDef.getPropertyValues().add("pathMatcher", (Object)pathMatcherRef).add("urlPathHelper", (Object)pathHelperRef);
        String order = element.getAttribute("order");
        handlerMappingDef.getPropertyValues().add("order", StringUtils.hasText((String)order) ? order : Integer.valueOf(0x7FFFFFFE));
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)handlerMappingDef);
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)handlerMappingDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerMappingDef, beanName));
        MvcNamespaceUtils.registerDefaultComponents(parserContext, source);
        return null;
    }

    private String registerResourceHandler(ParserContext parserContext, Element element, Object source) {
        ManagedList<? super Object> resourceTransformers;
        ManagedList<? super Object> resourceResolvers;
        String locationAttr = element.getAttribute("location");
        if (!StringUtils.hasText((String)locationAttr)) {
            parserContext.getReaderContext().error("The 'location' attribute is required.", parserContext.extractSource((Object)element));
            return null;
        }
        ManagedList locations = new ManagedList();
        locations.addAll(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)locationAttr)));
        RootBeanDefinition resourceHandlerDef = new RootBeanDefinition(ResourceHttpRequestHandler.class);
        resourceHandlerDef.setSource(source);
        resourceHandlerDef.setRole(2);
        resourceHandlerDef.getPropertyValues().add("locations", (Object)locations);
        String cacheSeconds = element.getAttribute("cache-period");
        if (StringUtils.hasText((String)cacheSeconds)) {
            resourceHandlerDef.getPropertyValues().add("cacheSeconds", (Object)cacheSeconds);
        }
        if (!(resourceResolvers = this.parseResourceResolvers(parserContext, element, source)).isEmpty()) {
            resourceHandlerDef.getPropertyValues().add("resourceResolvers", resourceResolvers);
        }
        if (!(resourceTransformers = this.parseResourceTransformers(parserContext, element, source)).isEmpty()) {
            resourceHandlerDef.getPropertyValues().add("resourceTransformers", resourceTransformers);
        }
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)resourceHandlerDef);
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)resourceHandlerDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)resourceHandlerDef, beanName));
        return beanName;
    }

    private ManagedList<? super Object> parseResourceResolvers(ParserContext parserContext, Element element, Object source) {
        Element resolversElement = DomUtils.getChildElementByTagName((Element)element, (String)"resolvers");
        ManagedList resourceResolvers = new ManagedList();
        if (resolversElement != null) {
            resourceResolvers.setSource(source);
            for (Element beanElement : DomUtils.getChildElementsByTagName((Element)resolversElement, (String[])new String[]{"bean", "ref"})) {
                Object object = parserContext.getDelegate().parsePropertySubElement(beanElement, null);
                resourceResolvers.add(object);
            }
        }
        return resourceResolvers;
    }

    private ManagedList<? super Object> parseResourceTransformers(ParserContext parserContext, Element element, Object source) {
        Element transformersElement = DomUtils.getChildElementByTagName((Element)element, (String)"transformers");
        ManagedList resourceTransformers = new ManagedList();
        if (transformersElement != null) {
            resourceTransformers.setSource(source);
            for (Element beanElement : DomUtils.getChildElementsByTagName((Element)transformersElement, (String[])new String[]{"bean", "ref"})) {
                Object object = parserContext.getDelegate().parsePropertySubElement(beanElement, null);
                resourceTransformers.add(object);
            }
        }
        return resourceTransformers;
    }
}

