/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.resource.CachingResourceResolver;
import org.springframework.web.servlet.resource.CachingResourceTransformer;
import org.springframework.web.servlet.resource.ContentVersionStrategy;
import org.springframework.web.servlet.resource.CssLinkResourceTransformer;
import org.springframework.web.servlet.resource.FixedVersionStrategy;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import org.springframework.web.servlet.resource.VersionStrategy;

public class ResourceHandlerRegistration {
    private static final String RESOURCE_CACHE_NAME = "spring-resourcehandler-cache";
    private final ResourceLoader resourceLoader;
    private final String[] pathPatterns;
    private final List<Resource> locations = new ArrayList<Resource>();
    private Integer cachePeriod;
    private List<ResourceResolver> customResolvers = new ArrayList<ResourceResolver>();
    private List<ResourceTransformer> customTransformers = new ArrayList<ResourceTransformer>();
    private Map<String, VersionStrategy> versionStrategies = new HashMap<String, VersionStrategy>();
    private boolean isDevMode = false;
    private Cache resourceCache;

    public ResourceHandlerRegistration(ResourceLoader resourceLoader, String ... pathPatterns) {
        Assert.notEmpty((Object[])pathPatterns, (String)"At least one path pattern is required for resource handling.");
        this.resourceLoader = resourceLoader;
        this.pathPatterns = pathPatterns;
    }

    public ResourceHandlerRegistration addResourceLocations(String ... resourceLocations) {
        for (String location : resourceLocations) {
            this.locations.add(this.resourceLoader.getResource(location));
        }
        return this;
    }

    public ResourceHandlerRegistration addResolver(ResourceResolver resolver) {
        Assert.notNull((Object)resolver, (String)"The provided ResourceResolver should not be null");
        this.customResolvers.add(resolver);
        return this;
    }

    public ResourceHandlerRegistration addTransformer(ResourceTransformer transformer) {
        Assert.notNull((Object)transformer, (String)"The provided ResourceTransformer should not be null");
        this.customTransformers.add(transformer);
        return this;
    }

    public ResourceHandlerRegistration addVersionStrategy(VersionStrategy strategy, String ... pathPatterns) {
        for (String pattern : pathPatterns) {
            this.versionStrategies.put(pattern, strategy);
        }
        return this;
    }

    public ResourceHandlerRegistration addVersion(String fixedVersion, String ... pathPatterns) {
        this.addVersionStrategy(new FixedVersionStrategy(fixedVersion), pathPatterns);
        return this;
    }

    public ResourceHandlerRegistration addVersionHash(String ... pathPatterns) {
        this.addVersionStrategy(new ContentVersionStrategy(), pathPatterns);
        return this;
    }

    public ResourceHandlerRegistration enableDevMode() {
        this.isDevMode = true;
        return this;
    }

    public ResourceHandlerRegistration setCachePeriod(Integer cachePeriod) {
        this.cachePeriod = cachePeriod;
        return this;
    }

    protected String[] getPathPatterns() {
        return this.pathPatterns;
    }

    protected List<ResourceResolver> getResourceResolvers() {
        ArrayList<ResourceResolver> resolvers = new ArrayList<ResourceResolver>();
        boolean hasCachingResolver = false;
        if (!this.customResolvers.isEmpty() && ClassUtils.isAssignable(CachingResourceResolver.class, this.customResolvers.get(0).getClass())) {
            hasCachingResolver = true;
        }
        if (!hasCachingResolver && !this.isDevMode) {
            resolvers.add(new CachingResourceResolver(this.getDefaultResourceCache()));
        }
        resolvers.addAll(this.customResolvers);
        if (!this.versionStrategies.isEmpty()) {
            VersionResourceResolver versionResolver = new VersionResourceResolver();
            versionResolver.setStrategyMap(this.versionStrategies);
            resolvers.add(versionResolver);
        }
        resolvers.add(new PathResourceResolver());
        return resolvers;
    }

    protected List<ResourceTransformer> getResourceTransformers() {
        ArrayList<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>();
        boolean hasCachingTransformer = false;
        if (!this.customTransformers.isEmpty() || !this.versionStrategies.isEmpty()) {
            if (!this.customTransformers.isEmpty() && ClassUtils.isAssignable(CachingResourceTransformer.class, this.customTransformers.get(0).getClass())) {
                hasCachingTransformer = true;
            }
            if (!hasCachingTransformer && !this.isDevMode) {
                transformers.add(new CachingResourceTransformer(this.getDefaultResourceCache()));
            }
            transformers.addAll(this.customTransformers);
            if (!this.versionStrategies.isEmpty()) {
                int cssLinkTransformerPosition = hasCachingTransformer || !this.isDevMode ? 1 : 0;
                transformers.add(cssLinkTransformerPosition, new CssLinkResourceTransformer());
            }
        }
        return transformers;
    }

    protected ResourceHttpRequestHandler getRequestHandler() {
        List<ResourceTransformer> resourceTransformers;
        Assert.isTrue((!CollectionUtils.isEmpty(this.locations) ? 1 : 0) != 0, (String)"At least one location is required for resource handling.");
        ResourceHttpRequestHandler requestHandler = new ResourceHttpRequestHandler();
        List<ResourceResolver> resourceResolvers = this.getResourceResolvers();
        if (!resourceResolvers.isEmpty()) {
            requestHandler.setResourceResolvers(resourceResolvers);
        }
        if (!(resourceTransformers = this.getResourceTransformers()).isEmpty()) {
            requestHandler.setResourceTransformers(resourceTransformers);
        }
        requestHandler.setLocations(this.locations);
        if (this.cachePeriod != null) {
            requestHandler.setCacheSeconds(this.cachePeriod);
        }
        return requestHandler;
    }

    private Cache getDefaultResourceCache() {
        if (this.resourceCache == null) {
            this.resourceCache = new ConcurrentMapCache(RESOURCE_CACHE_NAME);
        }
        return this.resourceCache;
    }
}

