/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class PathResourceResolver
extends AbstractResourceResolver {
    @Override
    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, locations);
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(resourceUrlPath, locations) != null ? resourceUrlPath : null;
    }

    private Resource getResource(String path, List<? extends Resource> locations) {
        for (Resource resource : locations) {
            try {
                Resource resource2;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Checking location=[" + resource + "]"));
                }
                if ((resource2 = resource.createRelative(path)).exists() && resource2.isReadable()) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)"Found match");
                    }
                    return resource2;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)"No match");
            }
            catch (IOException ex) {
                this.logger.trace((Object)"Failure checking for relative resource. Trying next location.", (Throwable)ex);
            }
        }
        return null;
    }
}

