/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.DefaultResourceResolverChain;
import org.springframework.web.servlet.resource.DefaultResourceTransformerChain;
import org.springframework.web.servlet.resource.EncodedResource;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.support.WebContentGenerator;

public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
InitializingBean {
    private static final Log logger = LogFactory.getLog(ResourceHttpRequestHandler.class);
    private static final boolean jafPresent = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)ResourceHttpRequestHandler.class.getClassLoader());
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private List<Resource> locations;
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>();
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>();

    public ResourceHttpRequestHandler() {
        super("GET", "HEAD");
        this.resourceResolvers.add(new PathResourceResolver());
    }

    public void setLocations(List<Resource> locations) {
        Assert.notEmpty(locations, (String)"Locations list must not be empty");
        this.locations = locations;
    }

    public List<Resource> getLocations() {
        return this.locations;
    }

    public void setResourceResolvers(List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isWarnEnabled() && CollectionUtils.isEmpty(this.locations)) {
            logger.warn((Object)"Locations list is empty. No resources will be served");
        }
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkAndPrepare(request, response, true);
        Resource resource = this.getResource(request);
        if (resource == null) {
            logger.trace((Object)"No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        MediaType mediaType = this.getMediaType(resource);
        if (mediaType != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Determined media type '" + mediaType + "' for " + resource));
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("No media type found for " + resource + " - not sending a content-type header"));
        }
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            logger.trace((Object)"Resource not modified - returning 304");
            return;
        }
        this.setHeaders(response, resource, mediaType);
        if ("HEAD".equals(request.getMethod())) {
            logger.trace((Object)"HEAD request - skipping content");
            return;
        }
        this.writeContent(response, resource);
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (!StringUtils.hasText((String)path) || this.isInvalidPath(path)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring invalid resource path [" + path + "]"));
            }
            return null;
        }
        DefaultResourceResolverChain resolveChain = new DefaultResourceResolverChain(this.getResourceResolvers());
        Resource resource = resolveChain.resolveResource(request, path, this.getLocations());
        if (resource == null || this.getResourceTransformers().isEmpty()) {
            return resource;
        }
        DefaultResourceTransformerChain transformChain = new DefaultResourceTransformerChain(resolveChain, this.getResourceTransformers());
        resource = transformChain.transform(request, resource);
        return resource;
    }

    protected boolean isInvalidPath(String path) {
        return path.contains("WEB-INF") || path.contains("META-INF") || StringUtils.cleanPath((String)path).startsWith("..");
    }

    protected MediaType getMediaType(Resource resource) {
        MediaType jafMediaType;
        MediaType mediaType = null;
        String mimeType = this.getServletContext().getMimeType(resource.getFilename());
        if (StringUtils.hasText((String)mimeType)) {
            mediaType = MediaType.parseMediaType((String)mimeType);
        }
        if (jafPresent && (mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals((Object)mediaType)) && (jafMediaType = ActivationMediaTypeFactory.getMediaType(resource.getFilename())) != null && !MediaType.APPLICATION_OCTET_STREAM.equals((Object)jafMediaType)) {
            mediaType = jafMediaType;
        }
        return mediaType;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Resource content too long (beyond Integer.MAX_VALUE): " + resource);
        }
        response.setContentLength((int)length);
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        if (resource instanceof EncodedResource) {
            response.setHeader(CONTENT_ENCODING, ((EncodedResource)resource).getContentEncoding());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContent(HttpServletResponse response, Resource resource) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            StreamUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    public String toString() {
        return "ResourceHttpRequestHandler [locations=" + this.getLocations() + ", resolvers=" + this.getResourceResolvers() + "]";
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (mappingLocation.exists()) {
                InputStream inputStream = null;
                try {
                    inputStream = mappingLocation.getInputStream();
                    MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                    return mimetypesFileTypeMap;
                }
                catch (IOException ex) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null;
        }
    }
}

