/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;

public class ResourceUrlEncodingFilter
extends OncePerRequestFilter {
    private static final Log logger = LogFactory.getLog(ResourceUrlEncodingFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)new ResourceUrlEncodingResponseWrapper(request, response));
    }

    private static class ResourceUrlEncodingResponseWrapper
    extends HttpServletResponseWrapper {
        private HttpServletRequest request;

        private ResourceUrlEncodingResponseWrapper(HttpServletRequest request, HttpServletResponse wrapped) {
            super(wrapped);
            this.request = request;
        }

        public String encodeURL(String url) {
            String name = ResourceUrlProviderExposingInterceptor.RESOURCE_URL_PROVIDER_ATTR;
            ResourceUrlProvider urlProvider = (ResourceUrlProvider)this.request.getAttribute(name);
            if (urlProvider != null) {
                String translatedUrl = urlProvider.getForRequestUrl(this.request, url);
                if (translatedUrl != null) {
                    return super.encodeURL(translatedUrl);
                }
            } else {
                logger.debug((Object)("Request attribute exposing ResourceUrlProvider not found under name: " + name));
            }
            return super.encodeURL(url);
        }
    }
}

