/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.CacheControl;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;

public class WebContentInterceptor
extends WebContentGenerator
implements HandlerInterceptor {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Map<String, CacheControl> cacheMappings = new HashMap<String, CacheControl>();

    public WebContentInterceptor() {
        super(false);
    }

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setCacheMappings(Properties cacheMappings) {
        this.cacheMappings.clear();
        Enumeration<?> propNames = cacheMappings.propertyNames();
        while (propNames.hasMoreElements()) {
            String path = (String)propNames.nextElement();
            int cacheSeconds = Integer.valueOf(cacheMappings.getProperty(path));
            if (cacheSeconds > 0) {
                this.cacheMappings.put(path, CacheControl.maxAge((long)cacheSeconds, (TimeUnit)TimeUnit.SECONDS));
                continue;
            }
            if (cacheSeconds == 0) {
                this.cacheMappings.put(path, CacheControl.noStore());
                continue;
            }
            this.cacheMappings.put(path, CacheControl.empty());
        }
    }

    public void addCacheMapping(CacheControl cacheControl, String ... paths) {
        for (String path : paths) {
            this.cacheMappings.put(path, cacheControl);
        }
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        CacheControl cacheControl;
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up cache seconds for [" + lookupPath + "]"));
        }
        if ((cacheControl = this.lookupCacheSeconds(lookupPath)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying CacheControl to [" + lookupPath + "]"));
            }
            this.checkAndPrepare(request, response, cacheControl);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying default cache seconds to [" + lookupPath + "]"));
            }
            this.checkAndPrepare(request, response);
        }
        return true;
    }

    protected CacheControl lookupCacheSeconds(String urlPath) {
        CacheControl cacheControl = this.cacheMappings.get(urlPath);
        if (cacheControl == null) {
            for (String registeredPath : this.cacheMappings.keySet()) {
                if (!this.pathMatcher.match(registeredPath, urlPath)) continue;
                cacheControl = this.cacheMappings.get(registeredPath);
            }
        }
        return cacheControl;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

