/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

public class SseEmitter
extends ResponseBodyEmitter {
    static final MediaType TEXT_PLAIN = new MediaType("text", "plain", Charset.forName("UTF-8"));

    @Override
    protected void extendResponse(ServerHttpResponse outputMessage) {
        super.extendResponse(outputMessage);
        HttpHeaders headers = outputMessage.getHeaders();
        if (headers.getContentType() == null) {
            headers.setContentType(new MediaType("text", "event-stream"));
        }
    }

    @Override
    public void send(Object object) throws IOException {
        this.send(object, null);
    }

    @Override
    public void send(Object object, MediaType mediaType) throws IOException {
        if (object == null) {
            return;
        }
        this.send(SseEmitter.event().data(object, mediaType));
    }

    public void send(SseEventBuilder builder) throws IOException {
        Map<Object, MediaType> map = builder.build();
        for (Map.Entry<Object, MediaType> entry : map.entrySet()) {
            super.send(entry.getKey(), entry.getValue());
        }
    }

    public static SseEventBuilder event() {
        return new DefaultSseEventBuilder();
    }

    private static class DefaultSseEventBuilder
    implements SseEventBuilder {
        private final Map<Object, MediaType> map = new LinkedHashMap<Object, MediaType>(4);
        private StringBuilder sb;

        private DefaultSseEventBuilder() {
        }

        @Override
        public SseEventBuilder comment(String comment) {
            this.append(":").append(comment != null ? comment : "").append("\n");
            return this;
        }

        @Override
        public SseEventBuilder name(String name) {
            this.append("event:").append(name != null ? name : "").append("\n");
            return this;
        }

        @Override
        public SseEventBuilder id(String id) {
            this.append("id:").append(id != null ? id : "").append("\n");
            return this;
        }

        @Override
        public SseEventBuilder reconnectTime(long reconnectTimeMillis) {
            this.append("retry:").append(String.valueOf(reconnectTimeMillis)).append("\n");
            return this;
        }

        @Override
        public SseEventBuilder data(Object object) {
            return this.data(object, null);
        }

        @Override
        public SseEventBuilder data(Object object, MediaType mediaType) {
            this.append("data:");
            this.saveAppendedText();
            this.map.put(object, mediaType);
            this.append("\n");
            return this;
        }

        DefaultSseEventBuilder append(String text) {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            }
            this.sb.append(text);
            return this;
        }

        private void saveAppendedText() {
            if (this.sb != null) {
                this.map.put(this.sb.toString(), TEXT_PLAIN);
                this.sb = null;
            }
        }

        @Override
        public Map<Object, MediaType> build() {
            if (this.sb == null || this.sb.length() == 0 && this.map.isEmpty()) {
                return Collections.emptyMap();
            }
            this.append("\n");
            this.saveAppendedText();
            return this.map;
        }
    }

    public static interface SseEventBuilder {
        public SseEventBuilder comment(String var1);

        public SseEventBuilder name(String var1);

        public SseEventBuilder id(String var1);

        public SseEventBuilder reconnectTime(long var1);

        public SseEventBuilder data(Object var1);

        public SseEventBuilder data(Object var1, MediaType var2);

        public Map<Object, MediaType> build();
    }
}

