/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.CacheControl;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public abstract class WebContentGenerator
extends WebApplicationObjectSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    private static final String HEADER_PRAGMA = "Pragma";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private Set<String> supportedMethods;
    private boolean requireSession = false;
    private int cacheSeconds = -1;
    private boolean useExpiresHeader = true;
    private boolean useCacheControlHeader = true;
    private boolean useCacheControlNoStore = true;
    private boolean alwaysMustRevalidate = false;
    private boolean usePreviousHttpCachingBehavior = false;
    private final SimpleDateFormat dateFormat;
    private CacheControl cacheControl;

    public WebContentGenerator() {
        this(true);
    }

    public WebContentGenerator(boolean restrictDefaultSupportedMethods) {
        if (restrictDefaultSupportedMethods) {
            this.supportedMethods = new HashSet<String>(4);
            this.supportedMethods.add(METHOD_GET);
            this.supportedMethods.add(METHOD_HEAD);
            this.supportedMethods.add(METHOD_POST);
        }
        this.dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public WebContentGenerator(String ... supportedMethods) {
        this.supportedMethods = new HashSet<String>(Arrays.asList(supportedMethods));
        this.dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final void setSupportedMethods(String ... methods) {
        this.supportedMethods = methods != null ? new HashSet<String>(Arrays.asList(methods)) : null;
    }

    public final String[] getSupportedMethods() {
        return StringUtils.toStringArray(this.supportedMethods);
    }

    public final void setRequireSession(boolean requireSession) {
        this.requireSession = requireSession;
    }

    public final boolean isRequireSession() {
        return this.requireSession;
    }

    public void setCacheControl(CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    @Deprecated
    public final void setUseExpiresHeader(boolean useExpiresHeader) {
        this.useExpiresHeader = useExpiresHeader;
        this.usePreviousHttpCachingBehavior = true;
    }

    @Deprecated
    public final boolean isUseExpiresHeader() {
        return this.useExpiresHeader;
    }

    @Deprecated
    public final void setUseCacheControlHeader(boolean useCacheControlHeader) {
        this.useCacheControlHeader = useCacheControlHeader;
        this.usePreviousHttpCachingBehavior = true;
    }

    @Deprecated
    public final boolean isUseCacheControlHeader() {
        return this.useCacheControlHeader;
    }

    @Deprecated
    public final void setUseCacheControlNoStore(boolean useCacheControlNoStore) {
        this.useCacheControlNoStore = useCacheControlNoStore;
        this.usePreviousHttpCachingBehavior = true;
    }

    @Deprecated
    public final boolean isUseCacheControlNoStore() {
        return this.useCacheControlNoStore;
    }

    @Deprecated
    public void setAlwaysMustRevalidate(boolean mustRevalidate) {
        this.alwaysMustRevalidate = mustRevalidate;
        this.usePreviousHttpCachingBehavior = true;
    }

    @Deprecated
    public boolean isAlwaysMustRevalidate() {
        return this.alwaysMustRevalidate;
    }

    public final void setCacheSeconds(int seconds) {
        this.cacheSeconds = seconds;
        if (!this.usePreviousHttpCachingBehavior) {
            if (this.cacheSeconds > 0) {
                this.cacheControl = CacheControl.maxAge((long)seconds, (TimeUnit)TimeUnit.SECONDS);
            } else if (this.cacheSeconds == 0) {
                this.cacheControl = CacheControl.noStore();
            }
        }
    }

    public final int getCacheSeconds() {
        return this.cacheSeconds;
    }

    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.checkAndPrepare(request, response, this.cacheControl);
    }

    @Deprecated
    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response, boolean lastModified) throws ServletException {
        if (lastModified) {
            this.checkAndPrepare(request, response, this.cacheControl.mustRevalidate());
        } else {
            this.checkAndPrepare(request, response);
        }
    }

    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response, int cacheSeconds) throws ServletException {
        CacheControl cControl = cacheSeconds > 0 ? CacheControl.maxAge((long)cacheSeconds, (TimeUnit)TimeUnit.SECONDS) : (cacheSeconds == 0 ? CacheControl.noStore() : CacheControl.empty());
        this.checkAndPrepare(request, response, cControl);
    }

    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response, CacheControl cacheControl) throws ServletException {
        String ccValue;
        String method = request.getMethod();
        if (this.supportedMethods != null && !this.supportedMethods.contains(method)) {
            throw new HttpRequestMethodNotSupportedException(method, StringUtils.toStringArray(this.supportedMethods));
        }
        if (this.requireSession && request.getSession(false) == null) {
            throw new HttpSessionRequiredException("Pre-existing session required but none found");
        }
        if (this.usePreviousHttpCachingBehavior) {
            this.addHttp10CacheHeaders(response);
        } else if (cacheControl != null && (ccValue = cacheControl.getHeaderValue()) != null) {
            response.setHeader(HEADER_CACHE_CONTROL, ccValue);
        }
    }

    protected void addHttp10CacheHeaders(HttpServletResponse response) {
        if (this.cacheSeconds > 0) {
            this.cacheForSeconds(response, this.cacheSeconds, this.alwaysMustRevalidate);
        } else if (this.cacheSeconds == 0) {
            this.preventCaching(response);
        }
    }

    protected final void cacheForSeconds(HttpServletResponse response, int seconds, boolean mustRevalidate) {
        if (this.useExpiresHeader) {
            response.setHeader(HEADER_EXPIRES, this.dateFormat.format(System.currentTimeMillis() + (long)seconds * 1000L));
        }
        if (this.useCacheControlHeader) {
            String headerValue = "max-age=" + seconds;
            if (mustRevalidate) {
                headerValue = headerValue + ", must-revalidate";
            }
            response.setHeader(HEADER_CACHE_CONTROL, headerValue);
        }
    }

    protected final void preventCaching(HttpServletResponse response) {
        response.setHeader(HEADER_PRAGMA, "no-cache");
        if (this.useExpiresHeader) {
            response.setHeader(HEADER_EXPIRES, this.dateFormat.format(System.currentTimeMillis()));
        }
        if (this.useCacheControlHeader) {
            response.setHeader(HEADER_CACHE_CONTROL, "no-cache");
            if (this.useCacheControlNoStore) {
                response.addHeader(HEADER_CACHE_CONTROL, "no-store");
            }
        }
    }
}

