/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.accept.ServletPathExtensionContentNegotiationStrategy;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.DefaultResourceResolverChain;
import org.springframework.web.servlet.resource.DefaultResourceTransformerChain;
import org.springframework.web.servlet.resource.EncodedResource;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.VersionedResource;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;

public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
EmbeddedValueResolverAware,
InitializingBean,
CorsConfigurationSource {
    private static final boolean contentLengthLongAvailable = ClassUtils.hasMethod(ServletResponse.class, (String)"setContentLengthLong", (Class[])new Class[]{Long.TYPE});
    private static final Log logger = LogFactory.getLog(ResourceHttpRequestHandler.class);
    private static final String URL_RESOURCE_CHARSET_PREFIX = "[charset=";
    private final List<String> locationValues = new ArrayList<String>(4);
    private final List<Resource> locations = new ArrayList<Resource>(4);
    private final Map<Resource, Charset> locationCharsets = new HashMap<Resource, Charset>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    private ResourceHttpMessageConverter resourceHttpMessageConverter;
    private ResourceRegionHttpMessageConverter resourceRegionHttpMessageConverter;
    private ContentNegotiationManager contentNegotiationManager;
    private PathExtensionContentNegotiationStrategy contentNegotiationStrategy;
    private CorsConfiguration corsConfiguration;
    private UrlPathHelper urlPathHelper;
    private StringValueResolver embeddedValueResolver;

    public ResourceHttpRequestHandler() {
        super(HttpMethod.GET.name(), HttpMethod.HEAD.name());
    }

    public void setLocationValues(List<String> locationValues) {
        Assert.notNull(locationValues, (String)"Location values list must not be null");
        this.locationValues.clear();
        this.locationValues.addAll(locationValues);
    }

    public void setLocations(List<Resource> locations) {
        Assert.notNull(locations, (String)"Locations list must not be null");
        this.locations.clear();
        this.locations.addAll(locations);
    }

    public List<Resource> getLocations() {
        return this.locations;
    }

    public void setResourceResolvers(List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setResourceHttpMessageConverter(ResourceHttpMessageConverter messageConverter) {
        this.resourceHttpMessageConverter = messageConverter;
    }

    public ResourceHttpMessageConverter getResourceHttpMessageConverter() {
        return this.resourceHttpMessageConverter;
    }

    public void setResourceRegionHttpMessageConverter(ResourceRegionHttpMessageConverter messageConverter) {
        this.resourceRegionHttpMessageConverter = messageConverter;
    }

    public ResourceRegionHttpMessageConverter getResourceRegionHttpMessageConverter() {
        return this.resourceRegionHttpMessageConverter;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setCorsConfiguration(CorsConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        return this.corsConfiguration;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void afterPropertiesSet() throws Exception {
        this.resolveResourceLocations();
        if (logger.isWarnEnabled() && CollectionUtils.isEmpty(this.locations)) {
            logger.warn((Object)"Locations list is empty. No resources will be served unless a custom ResourceResolver is configured as an alternative to PathResourceResolver.");
        }
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        if (this.resourceHttpMessageConverter == null) {
            this.resourceHttpMessageConverter = new ResourceHttpMessageConverter();
        }
        if (this.resourceRegionHttpMessageConverter == null) {
            this.resourceRegionHttpMessageConverter = new ResourceRegionHttpMessageConverter();
        }
        this.contentNegotiationStrategy = this.initContentNegotiationStrategy();
    }

    private void resolveResourceLocations() {
        if (CollectionUtils.isEmpty(this.locationValues)) {
            return;
        }
        if (!CollectionUtils.isEmpty(this.locations)) {
            throw new IllegalArgumentException("Please set either Resource-based \"locations\" or String-based \"locationValues\", but not both.");
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        for (String location : this.locationValues) {
            if (this.embeddedValueResolver != null) {
                String resolvedLocation = this.embeddedValueResolver.resolveStringValue(location);
                if (resolvedLocation == null) {
                    throw new IllegalArgumentException("Location resolved to null: " + location);
                }
                location = resolvedLocation;
            }
            Charset charset = null;
            if ((location = location.trim()).startsWith(URL_RESOURCE_CHARSET_PREFIX)) {
                int endIndex = location.indexOf("]", URL_RESOURCE_CHARSET_PREFIX.length());
                if (endIndex == -1) {
                    throw new IllegalArgumentException("Invalid charset syntax in location: " + location);
                }
                String value = location.substring(URL_RESOURCE_CHARSET_PREFIX.length(), endIndex);
                charset = Charset.forName(value);
                location = location.substring(endIndex + 1);
            }
            Resource resource = applicationContext.getResource(location);
            this.locations.add(resource);
            if (charset == null) continue;
            if (!(resource instanceof UrlResource)) {
                throw new IllegalArgumentException("Unexpected charset for non-UrlResource: " + resource);
            }
            this.locationCharsets.put(resource, charset);
        }
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.locations)) {
            return;
        }
        for (int i = this.getResourceResolvers().size() - 1; i >= 0; --i) {
            if (!(this.getResourceResolvers().get(i) instanceof PathResourceResolver)) continue;
            PathResourceResolver pathResolver = (PathResourceResolver)this.getResourceResolvers().get(i);
            if (ObjectUtils.isEmpty((Object[])pathResolver.getAllowedLocations())) {
                pathResolver.setAllowedLocations(this.getLocations().toArray(new Resource[this.getLocations().size()]));
            }
            if (this.urlPathHelper == null) break;
            pathResolver.setLocationCharsets(this.locationCharsets);
            pathResolver.setUrlPathHelper(this.urlPathHelper);
            break;
        }
    }

    protected PathExtensionContentNegotiationStrategy initContentNegotiationStrategy() {
        PathExtensionContentNegotiationStrategy strategy;
        HashMap mediaTypes = null;
        if (this.getContentNegotiationManager() != null && (strategy = (PathExtensionContentNegotiationStrategy)this.getContentNegotiationManager().getStrategy(PathExtensionContentNegotiationStrategy.class)) != null) {
            mediaTypes = new HashMap(strategy.getMediaTypes());
        }
        return this.getServletContext() != null ? new ServletPathExtensionContentNegotiationStrategy(this.getServletContext(), mediaTypes) : new PathExtensionContentNegotiationStrategy(mediaTypes);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Resource resource = this.getResource(request);
        if (resource == null) {
            logger.trace((Object)"No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setHeader("Allow", this.getAllowHeader());
            return;
        }
        this.checkRequest(request);
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            logger.trace((Object)"Resource not modified - returning 304");
            return;
        }
        this.prepareResponse(response);
        MediaType mediaType = this.getMediaType(request, resource);
        if (mediaType != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Determined media type '" + mediaType + "' for " + resource));
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("No media type found for " + resource + " - not sending a content-type header"));
        }
        if ("HEAD".equals(request.getMethod())) {
            this.setHeaders(response, resource, mediaType);
            logger.trace((Object)"HEAD request - skipping content");
            return;
        }
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        if (request.getHeader("Range") == null) {
            this.setHeaders(response, resource, mediaType);
            this.resourceHttpMessageConverter.write((Object)resource, mediaType, (HttpOutputMessage)outputMessage);
        } else {
            response.setHeader("Accept-Ranges", "bytes");
            ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(request);
            try {
                List httpRanges = inputMessage.getHeaders().getRange();
                response.setStatus(206);
                if (httpRanges.size() == 1) {
                    ResourceRegion resourceRegion = ((HttpRange)httpRanges.get(0)).toResourceRegion(resource);
                    this.resourceRegionHttpMessageConverter.write((Object)resourceRegion, mediaType, (HttpOutputMessage)outputMessage);
                } else {
                    this.resourceRegionHttpMessageConverter.write((Object)HttpRange.toResourceRegions((List)httpRanges, (Resource)resource), mediaType, (HttpOutputMessage)outputMessage);
                }
            }
            catch (IllegalArgumentException ex) {
                response.setHeader("Content-Range", "bytes */" + resource.contentLength());
                response.sendError(416);
            }
        }
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        DefaultResourceResolverChain resolveChain;
        Resource resource;
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (!StringUtils.hasText((String)(path = this.processPath(path))) || this.isInvalidPath(path)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring invalid resource path [" + path + "]"));
            }
            return null;
        }
        if (path.contains("%")) {
            try {
                if (this.isInvalidPath(URLDecoder.decode(path, "UTF-8"))) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Ignoring invalid resource path with escape sequences [" + path + "]."));
                    }
                    return null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((resource = (resolveChain = new DefaultResourceResolverChain(this.getResourceResolvers())).resolveResource(request, path, this.getLocations())) == null || this.getResourceTransformers().isEmpty()) {
            return resource;
        }
        DefaultResourceTransformerChain transformChain = new DefaultResourceTransformerChain(resolveChain, this.getResourceTransformers());
        resource = transformChain.transform(request, resource);
        return resource;
    }

    protected String processPath(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            String string = path = slash ? "/" + path.substring(i) : path.substring(i);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Path after trimming leading '/' and control characters: " + path));
            }
            return path;
        }
        return slash ? "/" : "";
    }

    protected boolean isInvalidPath(String path) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Applying \"invalid path\" checks to path: " + path));
        }
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"WEB-INF\" or \"META-INF\".");
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Path represents URL or has \"url:\" prefix.");
                }
                return true;
            }
        }
        if (path.contains("..") && (path = StringUtils.cleanPath((String)path)).contains("../")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"../\" after call to StringUtils#cleanPath.");
            }
            return true;
        }
        return false;
    }

    protected MediaType getMediaType(HttpServletRequest request, Resource resource) {
        MediaType mediaType = this.getMediaType(resource);
        if (mediaType != null) {
            return mediaType;
        }
        return this.contentNegotiationStrategy.getMediaTypeForResource(resource);
    }

    @Deprecated
    protected MediaType getMediaType(Resource resource) {
        return null;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            if (contentLengthLongAvailable) {
                response.setContentLengthLong(length);
            } else {
                response.setHeader("Content-Length", Long.toString(length));
            }
        } else {
            response.setContentLength((int)length);
        }
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        if (resource instanceof EncodedResource) {
            response.setHeader("Content-Encoding", ((EncodedResource)resource).getContentEncoding());
        }
        if (resource instanceof VersionedResource) {
            response.setHeader("ETag", "\"" + ((VersionedResource)resource).getVersion() + "\"");
        }
        response.setHeader("Accept-Ranges", "bytes");
    }

    public String toString() {
        return "ResourceHttpRequestHandler [locations=" + this.getLocations() + ", resolvers=" + this.getResourceResolvers() + "]";
    }
}

