/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

public class ResponseStatusExceptionResolver
extends AbstractHandlerExceptionResolver
implements MessageSourceAware {
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            if (ex instanceof ResponseStatusException) {
                return this.resolveResponseStatusException((ResponseStatusException)ex, request, response, handler);
            }
            ResponseStatus status = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(ex.getClass(), ResponseStatus.class);
            if (status != null) {
                return this.resolveResponseStatus(status, request, response, handler, ex);
            }
            if (ex.getCause() instanceof Exception) {
                ex = (Exception)ex.getCause();
                return this.doResolveException(request, response, handler, ex);
            }
        }
        catch (Exception resolveEx) {
            this.logger.warn((Object)"Handling of @ResponseStatus resulted in Exception", (Throwable)resolveEx);
        }
        return null;
    }

    protected ModelAndView resolveResponseStatus(ResponseStatus responseStatus, HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        int statusCode = responseStatus.code().value();
        String reason = responseStatus.reason();
        return this.applyStatusAndReason(statusCode, reason, response);
    }

    protected ModelAndView resolveResponseStatusException(ResponseStatusException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        int statusCode = ex.getStatus().value();
        String reason = ex.getReason();
        this.applyStatusAndReason(statusCode, reason, response);
        return new ModelAndView();
    }

    protected ModelAndView applyStatusAndReason(int statusCode, String reason, HttpServletResponse response) throws IOException {
        if (this.messageSource != null) {
            reason = this.messageSource.getMessage(reason, null, reason, LocaleContextHolder.getLocale());
        }
        if (!StringUtils.hasLength((String)reason)) {
            response.sendError(statusCode);
        } else {
            response.sendError(statusCode, reason);
        }
        return new ModelAndView();
    }
}

