/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class HttpSessionHandshakeInterceptor
implements HandshakeInterceptor {
    private Collection<String> attributeNames;

    public HttpSessionHandshakeInterceptor() {
        this(null);
    }

    public HttpSessionHandshakeInterceptor(Collection<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    @Override
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        ServletServerHttpRequest servletRequest;
        HttpSession session;
        if (request instanceof ServletServerHttpRequest && (session = (servletRequest = (ServletServerHttpRequest)request).getServletRequest().getSession(false)) != null) {
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!CollectionUtils.isEmpty(this.attributeNames) && !this.attributeNames.contains(name)) continue;
                attributes.put(name, session.getAttribute(name));
            }
        }
        return true;
    }

    @Override
    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception ex) {
    }
}

