/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.Arrays;
import java.util.List;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.sockjs.transport.handler.WebSocketTransportHandler;

public abstract class AbstractWebSocketHandlerRegistration<M>
implements WebSocketHandlerRegistration {
    private final TaskScheduler sockJsTaskScheduler;
    private MultiValueMap<WebSocketHandler, String> handlerMap = new LinkedMultiValueMap();
    private HandshakeHandler handshakeHandler;
    private HandshakeInterceptor[] interceptors;
    private SockJsServiceRegistration sockJsServiceRegistration;

    public AbstractWebSocketHandlerRegistration(TaskScheduler defaultTaskScheduler) {
        this.sockJsTaskScheduler = defaultTaskScheduler;
    }

    @Override
    public WebSocketHandlerRegistration addHandler(WebSocketHandler handler, String ... paths) {
        Assert.notNull((Object)handler);
        Assert.notEmpty((Object[])paths);
        this.handlerMap.put((Object)handler, Arrays.asList(paths));
        return this;
    }

    @Override
    public WebSocketHandlerRegistration setHandshakeHandler(HandshakeHandler handshakeHandler) {
        this.handshakeHandler = handshakeHandler;
        return this;
    }

    protected HandshakeHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    @Override
    public WebSocketHandlerRegistration addInterceptors(HandshakeInterceptor ... interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    protected HandshakeInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    @Override
    public SockJsServiceRegistration withSockJS() {
        this.sockJsServiceRegistration = new SockJsServiceRegistration(this.sockJsTaskScheduler);
        if (this.interceptors != null) {
            this.sockJsServiceRegistration.setInterceptors(this.interceptors);
        }
        if (this.handshakeHandler != null) {
            WebSocketTransportHandler transportHandler = new WebSocketTransportHandler(this.handshakeHandler);
            this.sockJsServiceRegistration.setTransportHandlerOverrides(transportHandler);
        }
        return this.sockJsServiceRegistration;
    }

    protected final M getMappings() {
        M mappings = this.createMappings();
        if (this.sockJsServiceRegistration != null) {
            SockJsService sockJsService = this.sockJsServiceRegistration.getSockJsService();
            for (WebSocketHandler wsHandler : this.handlerMap.keySet()) {
                for (String path : (List)this.handlerMap.get((Object)wsHandler)) {
                    String pathPattern = path.endsWith("/") ? path + "**" : path + "/**";
                    this.addSockJsServiceMapping(mappings, sockJsService, wsHandler, pathPattern);
                }
            }
        } else {
            HandshakeHandler handshakeHandler = this.getOrCreateHandshakeHandler();
            for (WebSocketHandler wsHandler : this.handlerMap.keySet()) {
                for (String path : (List)this.handlerMap.get((Object)wsHandler)) {
                    this.addWebSocketHandlerMapping(mappings, wsHandler, handshakeHandler, this.interceptors, path);
                }
            }
        }
        return mappings;
    }

    private HandshakeHandler getOrCreateHandshakeHandler() {
        return this.handshakeHandler != null ? this.handshakeHandler : new DefaultHandshakeHandler();
    }

    protected abstract M createMappings();

    protected abstract void addSockJsServiceMapping(M var1, SockJsService var2, WebSocketHandler var3, String var4);

    protected abstract void addWebSocketHandlerMapping(M var1, WebSocketHandler var2, HandshakeHandler var3, HandshakeInterceptor[] var4, String var5);
}

