/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public class ServerEndpointExporter
extends WebApplicationObjectSupport
implements BeanPostProcessor,
InitializingBean {
    private ServerContainer serverContainer;
    private List<Class<?>> annotatedEndpointClasses;
    private Set<Class<?>> annotatedEndpointBeanTypes;

    public void setServerContainer(ServerContainer serverContainer) {
        this.serverContainer = serverContainer;
    }

    protected ServerContainer getServerContainer() {
        return this.serverContainer;
    }

    public void setAnnotatedEndpointClasses(Class<?> ... annotatedEndpointClasses) {
        this.annotatedEndpointClasses = Arrays.asList(annotatedEndpointClasses);
    }

    protected void initApplicationContext(ApplicationContext context) {
        String[] beanNames;
        super.initApplicationContext(context);
        this.annotatedEndpointBeanTypes = new LinkedHashSet();
        for (String beanName : beanNames = context.getBeanNamesForAnnotation(ServerEndpoint.class)) {
            Class beanType = context.getType(beanName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Detected @ServerEndpoint bean '" + beanName + "', registering it as an endpoint by type"));
            }
            this.annotatedEndpointBeanTypes.add(beanType);
        }
    }

    protected void initServletContext(ServletContext servletContext) {
        if (this.serverContainer == null) {
            this.serverContainer = (ServerContainer)servletContext.getAttribute("javax.websocket.server.ServerContainer");
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.getServerContainer() != null ? 1 : 0) != 0, (String)"javax.websocket.server.ServerContainer not available");
        this.registerEndpoints();
    }

    protected void registerEndpoints() {
        LinkedHashSet endpointClasses = new LinkedHashSet();
        if (this.annotatedEndpointClasses != null) {
            endpointClasses.addAll(this.annotatedEndpointClasses);
        }
        if (this.annotatedEndpointBeanTypes != null) {
            endpointClasses.addAll(this.annotatedEndpointBeanTypes);
        }
        for (Class clazz : endpointClasses) {
            this.registerEndpoint(clazz);
        }
    }

    private void registerEndpoint(Class<?> endpointClass) {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Registering @ServerEndpoint type: " + endpointClass));
            }
            this.getServerContainer().addEndpoint(endpointClass);
        }
        catch (DeploymentException ex) {
            throw new IllegalStateException("Failed to register @ServerEndpoint type " + endpointClass, ex);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof ServerEndpointConfig) {
            ServerEndpointConfig endpointConfig = (ServerEndpointConfig)bean;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Registering bean '" + beanName + "' as javax.websocket.Endpoint under path " + endpointConfig.getPath()));
                }
                this.getServerContainer().addEndpoint(endpointConfig);
            }
            catch (DeploymentException ex) {
                throw new IllegalStateException("Failed to deploy Endpoint bean with name '" + bean + "'", ex);
            }
        }
        return bean;
    }
}

