/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class OriginHandshakeInterceptor
implements HandshakeInterceptor {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final List<String> allowedOrigins = new ArrayList<String>();

    public void setAllowedOrigins(Collection<String> allowedOrigins) {
        this.allowedOrigins.clear();
        if (allowedOrigins != null) {
            this.allowedOrigins.addAll(allowedOrigins);
        }
    }

    @Override
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        if (!this.isValidOrigin(request)) {
            response.setStatusCode(HttpStatus.FORBIDDEN);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Handshake request rejected, Origin header value " + request.getHeaders().getOrigin() + " not allowed"));
            }
            return false;
        }
        return true;
    }

    protected boolean isValidOrigin(ServerHttpRequest request) {
        return this.allowedOrigins.contains(request.getHeaders().getOrigin());
    }

    @Override
    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

