/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractTyrusRequestUpgradeStrategy;

public class WebLogicRequestUpgradeStrategy
extends AbstractTyrusRequestUpgradeStrategy {
    private static final AbstractTyrusRequestUpgradeStrategy.TyrusEndpointHelper endpointHelper = new AbstractTyrusRequestUpgradeStrategy.Tyrus135EndpointHelper();
    private static final TyrusMuxableWebSocketHelper webSocketHelper = new TyrusMuxableWebSocketHelper();
    private static final WebLogicServletWriterHelper servletWriterHelper = new WebLogicServletWriterHelper();
    private static final Connection.CloseListener noOpCloseListener = new Connection.CloseListener(){

        public void close(CloseReason reason) {
        }
    };

    @Override
    protected AbstractTyrusRequestUpgradeStrategy.TyrusEndpointHelper getEndpointHelper() {
        return endpointHelper;
    }

    @Override
    protected void handleSuccess(HttpServletRequest request, HttpServletResponse response, WebSocketEngine.UpgradeInfo upgradeInfo, TyrusUpgradeResponse upgradeResponse) throws IOException, ServletException {
        response.setStatus(upgradeResponse.getStatus());
        for (Map.Entry entry : upgradeResponse.getHeaders().entrySet()) {
            response.addHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(-1L);
        Object nativeRequest = WebLogicRequestUpgradeStrategy.getNativeRequest((ServletRequest)request);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(nativeRequest);
        Object httpSocket = beanWrapper.getPropertyValue("connection.connectionHandler.rawConnection");
        Object webSocket = WebLogicRequestUpgradeStrategy.webSocketHelper.newInstance(httpSocket);
        WebLogicRequestUpgradeStrategy.webSocketHelper.upgrade(webSocket, httpSocket, request.getServletContext());
        response.flushBuffer();
        boolean isProtected = request.getUserPrincipal() != null;
        Writer servletWriter = WebLogicRequestUpgradeStrategy.servletWriterHelper.newInstance(response, webSocket, isProtected);
        Connection connection = upgradeInfo.createConnection(servletWriter, noOpCloseListener);
        new BeanWrapperImpl(webSocket).setPropertyValue("connection", (Object)connection);
        new BeanWrapperImpl((Object)servletWriter).setPropertyValue("connection", (Object)connection);
        WebLogicRequestUpgradeStrategy.webSocketHelper.registerForReadEvent(webSocket);
    }

    private static Object getNativeRequest(ServletRequest request) {
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return request;
    }

    private static class WebLogicServletWriterHelper {
        private static final Constructor<?> constructor;

        private WebLogicServletWriterHelper() {
        }

        private Writer newInstance(HttpServletResponse response, Object webSocket, boolean isProtected) {
            try {
                return (Writer)constructor.newInstance(webSocket, response, null, isProtected);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to create TyrusServletWriter", ex);
            }
        }

        static {
            try {
                ClassLoader loader = WebLogicRequestUpgradeStrategy.class.getClassLoader();
                Class<?> type = loader.loadClass("weblogic.websocket.tyrus.TyrusServletWriter");
                Class<?> listenerType = loader.loadClass("weblogic.websocket.tyrus.TyrusServletWriter$CloseListener");
                Class<?> webSocketType = TyrusMuxableWebSocketHelper.webSocketType;
                Class<HttpServletResponse> responseType = HttpServletResponse.class;
                constructor = type.getDeclaredConstructor(webSocketType, responseType, listenerType, Boolean.TYPE);
                ReflectionUtils.makeAccessible(constructor);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible WebSocket version found", ex);
            }
        }
    }

    private static class TyrusMuxableWebSocketHelper {
        public static final Class<?> webSocketType;
        private static final Constructor<?> webSocketConstructor;
        private static final Method webSocketUpgradeMethod;
        private static final Method webSocketReadEventMethod;

        private TyrusMuxableWebSocketHelper() {
        }

        private Object newInstance(Object httpSocket) {
            try {
                return webSocketConstructor.newInstance(httpSocket);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to create TyrusMuxableWebSocket", ex);
            }
        }

        private void upgrade(Object webSocket, Object httpSocket, ServletContext servletContext) {
            try {
                webSocketUpgradeMethod.invoke(webSocket, httpSocket, servletContext);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to upgrade TyrusMuxableWebSocket", ex);
            }
        }

        private void registerForReadEvent(Object webSocket) {
            try {
                webSocketReadEventMethod.invoke(webSocket, new Object[0]);
            }
            catch (Exception ex) {
                throw new HandshakeFailureException("Failed to register WebSocket for read event", ex);
            }
        }

        static {
            try {
                ClassLoader classLoader = WebLogicRequestUpgradeStrategy.class.getClassLoader();
                Class<?> socketType = classLoader.loadClass("weblogic.socket.MuxableSocket");
                Class<?> httpSocketType = classLoader.loadClass("weblogic.servlet.internal.MuxableSocketHTTP");
                webSocketType = classLoader.loadClass("weblogic.websocket.tyrus.TyrusMuxableWebSocket");
                webSocketConstructor = webSocketType.getDeclaredConstructor(httpSocketType);
                webSocketUpgradeMethod = webSocketType.getMethod("upgrade", socketType, ServletContext.class);
                webSocketReadEventMethod = webSocketType.getMethod("registerForReadEvent", new Class[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("No compatible WebSocket version found", ex);
            }
        }
    }
}

