/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.remoting.httpinvoker.AbstractHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.support.RemoteInvocationResult;

public class SimpleHttpInvokerRequestExecutor
extends AbstractHttpInvokerRequestExecutor {
    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        HttpURLConnection con = this.openConnection(config);
        this.prepareConnection(con, baos.size());
        this.writeRequestBody(config, con, baos);
        InputStream responseBody = this.readResponseBody(config, con);
        return this.readRemoteInvocationResult(responseBody, config.getCodebaseUrl());
    }

    protected HttpURLConnection openConnection(HttpInvokerClientConfiguration config) throws IOException {
        URLConnection con = new URL(config.getServiceUrl()).openConnection();
        if (!(con instanceof HttpURLConnection)) {
            throw new IOException("Service URL [" + config.getServiceUrl() + "] is not an HTTP URL");
        }
        return (HttpURLConnection)con;
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-java-serialized-object");
        con.setRequestProperty("Content-Length", Integer.toString(contentLength));
    }

    protected void writeRequestBody(HttpInvokerClientConfiguration config, HttpURLConnection con, ByteArrayOutputStream baos) throws IOException {
        baos.writeTo(con.getOutputStream());
    }

    protected InputStream readResponseBody(HttpInvokerClientConfiguration config, HttpURLConnection con) throws IOException {
        return con.getInputStream();
    }
}

