/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.OrderComparator;
import org.springframework.transaction.support.TransactionSynchronization;

public abstract class TransactionSynchronizationManager {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$support$TransactionSynchronizationManager == null ? (class$org$springframework$transaction$support$TransactionSynchronizationManager = TransactionSynchronizationManager.class$("org.springframework.transaction.support.TransactionSynchronizationManager")) : class$org$springframework$transaction$support$TransactionSynchronizationManager));
    private static final ThreadLocal resources = new ThreadLocal();
    private static final ThreadLocal synchronizations = new ThreadLocal();
    private static final Comparator synchronizationComparator = new OrderComparator();
    private static final ThreadLocal currentTransactionName = new ThreadLocal();
    private static final ThreadLocal currentTransactionReadOnly = new ThreadLocal();
    private static final ThreadLocal actualTransactionActive = new ThreadLocal();
    static /* synthetic */ Class class$org$springframework$transaction$support$TransactionSynchronizationManager;

    public static Map getResourceMap() {
        HashMap map = (HashMap)resources.get();
        if (map == null) {
            map = new HashMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public static boolean hasResource(Object key) {
        Map map = (Map)resources.get();
        return map != null && map.containsKey(key);
    }

    public static Object getResource(Object key) {
        Map map = (Map)resources.get();
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        if (value != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved value [" + value + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        HashMap<Object, Object> map = (HashMap<Object, Object>)resources.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
            resources.set(map);
        }
        if (map.containsKey(key)) {
            throw new IllegalStateException("Already value [" + map.get(key) + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        map.put(key, value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound value [" + value + "] for key [" + key + "] to thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        Map map = (Map)resources.get();
        if (map == null || !map.containsKey(key)) {
            throw new IllegalStateException("No value for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        Object value = map.remove(key);
        if (map.isEmpty()) {
            resources.set(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed value [" + value + "] for key [" + key + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static boolean isSynchronizationActive() {
        return synchronizations.get() != null;
    }

    public static void initSynchronization() throws IllegalStateException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        logger.debug((Object)"Initializing transaction synchronization");
        synchronizations.set(new LinkedList());
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        List synchs = (List)synchronizations.get();
        synchs.add(synchronization);
        Collections.sort(synchs, synchronizationComparator);
    }

    public static List getSynchronizations() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        List synchs = (List)synchronizations.get();
        return Collections.unmodifiableList(new LinkedList(synchs));
    }

    public static void clearSynchronization() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        logger.debug((Object)"Clearing transaction synchronization");
        synchronizations.set(null);
    }

    public static void setCurrentTransactionName(String name) {
        currentTransactionName.set(name);
    }

    public static String getCurrentTransactionName() {
        return (String)currentTransactionName.get();
    }

    public static void setCurrentTransactionReadOnly(boolean readOnly) {
        currentTransactionReadOnly.set(readOnly ? Boolean.TRUE : null);
    }

    public static boolean isCurrentTransactionReadOnly() {
        return currentTransactionReadOnly.get() != null;
    }

    public static void setActualTransactionActive(boolean active) {
        actualTransactionActive.set(active ? Boolean.TRUE : null);
    }

    public static boolean isActualTransactionActive() {
        return actualTransactionActive.get() != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

