/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.SqlParameter;

public abstract class RdbmsOperation
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JdbcTemplate jdbcTemplate = new JdbcTemplate();
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private boolean returnGeneratedKeys = false;
    private String[] generatedKeysColumnNames = null;
    private String sql;
    private List declaredParameters = new LinkedList();
    private boolean compiled;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        if (jdbcTemplate == null) {
            throw new IllegalArgumentException("jdbcTemplate must not be null");
        }
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public void setFetchSize(int fetchSize) {
        this.jdbcTemplate.setFetchSize(fetchSize);
    }

    public void setMaxRows(int maxRows) {
        this.jdbcTemplate.setMaxRows(maxRows);
    }

    public void setQueryTimeout(int queryTimeout) {
        this.jdbcTemplate.setQueryTimeout(queryTimeout);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("The updateableResults flag must be set before the operation is compiled");
        }
        this.updatableResults = updatableResults;
    }

    public boolean isUpdatableResults() {
        return this.updatableResults;
    }

    public void setReturnGeneratedKeys(boolean returnGeneratedKeys) {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("The returnGeneratedKeys flag must be set before the operation is compiled");
        }
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public void setGeneratedKeysColumnNames(String[] names) {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("The column names for the generated keys must be set before the operation is compiled");
        }
        this.generatedKeysColumnNames = names;
    }

    public String[] getGeneratedKeysColumnNames() {
        return this.generatedKeysColumnNames;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setTypes(int[] types) throws InvalidDataAccessApiUsageException {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("Cannot add parameters once query is compiled");
        }
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                this.declareParameter(new SqlParameter(types[i]));
            }
        }
    }

    public void declareParameter(SqlParameter param) throws InvalidDataAccessApiUsageException {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("Cannot add parameters once query is compiled");
        }
        this.declaredParameters.add(param);
    }

    protected List getDeclaredParameters() {
        return this.declaredParameters;
    }

    public void afterPropertiesSet() {
        this.compile();
    }

    public final void compile() throws InvalidDataAccessApiUsageException {
        if (!this.isCompiled()) {
            if (this.getSql() == null) {
                throw new InvalidDataAccessApiUsageException("Property 'sql' is required");
            }
            try {
                this.jdbcTemplate.afterPropertiesSet();
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidDataAccessApiUsageException(ex.getMessage());
            }
            this.compileInternal();
            this.compiled = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RdbmsOperation with SQL [" + this.getSql() + "] compiled"));
            }
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    protected void checkCompiled() {
        if (!this.isCompiled()) {
            this.logger.debug((Object)"SQL operation not compiled before execution - invoking compile");
            this.compile();
        }
    }

    protected void validateParameters(Object[] parameters) throws InvalidDataAccessApiUsageException {
        this.checkCompiled();
        int declaredInParameters = 0;
        if (this.declaredParameters != null) {
            Iterator it = this.declaredParameters.iterator();
            while (it.hasNext()) {
                Object param = it.next();
                if (param instanceof ResultSetSupportingSqlParameter) continue;
                if (!(this.supportsLobParameters() || ((SqlParameter)param).getSqlType() != 2004 && ((SqlParameter)param).getSqlType() != 2005)) {
                    throw new InvalidDataAccessApiUsageException("BLOB or CLOB parameters are not allowed for this kind of operation");
                }
                ++declaredInParameters;
            }
        }
        if (parameters != null) {
            if (this.declaredParameters == null) {
                throw new InvalidDataAccessApiUsageException("Didn't expect any parameters: none was declared");
            }
            if (parameters.length < declaredInParameters) {
                throw new InvalidDataAccessApiUsageException(parameters.length + " parameters were supplied, but " + declaredInParameters + " in parameters were declared in class [" + this.getClass().getName() + "]");
            }
            if (!this.allowsUnusedParameters() && parameters.length > this.declaredParameters.size()) {
                throw new InvalidDataAccessApiUsageException(parameters.length + " parameters were supplied, but " + this.declaredParameters.size() + " parameters were declared " + "in class [" + this.getClass().getName() + "]");
            }
        } else if (this.declaredParameters != null && !this.declaredParameters.isEmpty()) {
            throw new InvalidDataAccessApiUsageException(this.declaredParameters.size() + " parameters must be supplied");
        }
    }

    protected void validateNamedParameters(Map parameters) throws InvalidDataAccessApiUsageException {
        this.checkCompiled();
        if (this.declaredParameters != null) {
            Iterator it = this.declaredParameters.iterator();
            while (it.hasNext()) {
                Object param = it.next();
                if (param instanceof ResultSetSupportingSqlParameter) continue;
                if (!(this.supportsLobParameters() || ((SqlParameter)param).getSqlType() != 2004 && ((SqlParameter)param).getSqlType() != 2005)) {
                    throw new InvalidDataAccessApiUsageException("BLOB or CLOB parameters are not allowed for this kind of operation");
                }
                if (((SqlParameter)param).getName() == null) {
                    throw new InvalidDataAccessApiUsageException("All parameters must have name specified when using the methods dedicated to named parameter support");
                }
                if (parameters.containsKey(((SqlParameter)param).getName())) continue;
                throw new InvalidDataAccessApiUsageException("The parameter named '" + ((SqlParameter)param).getName() + "' were not among the parameters supplied: " + parameters.keySet());
            }
        }
        if (parameters != null && parameters.size() > 0) {
            if (this.declaredParameters == null) {
                throw new InvalidDataAccessApiUsageException("Didn't expect any parameters: none was declared");
            }
        } else if (this.declaredParameters != null && !this.declaredParameters.isEmpty()) {
            throw new InvalidDataAccessApiUsageException("Parameters must be supplied");
        }
    }

    protected abstract void compileInternal() throws InvalidDataAccessApiUsageException;

    protected boolean supportsLobParameters() {
        return true;
    }

    protected boolean allowsUnusedParameters() {
        return false;
    }
}

