/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;

public abstract class AbstractMessageListenerContainer
extends AbstractJmsListeningContainer {
    private Object destination;
    private String messageSelector;
    private volatile Object messageListener;
    private boolean subscriptionDurable = false;
    private String durableSubscriptionName;
    private ExceptionListener exceptionListener;
    private boolean exposeListenerSession = true;
    private boolean acceptMessagesWhileStopping = false;
    static /* synthetic */ Class class$javax$jms$MessageListener;
    static /* synthetic */ Class class$org$springframework$jms$listener$SessionAwareMessageListener;

    public void setDestination(Destination destination) {
        Assert.notNull(destination, "'destination' must not be null");
        this.destination = destination;
        if (destination instanceof Topic && !(destination instanceof Queue)) {
            this.setPubSubDomain(true);
        }
    }

    protected Destination getDestination() {
        return this.destination instanceof Destination ? (Destination)this.destination : null;
    }

    public void setDestinationName(String destinationName) {
        Assert.notNull(destinationName, "'destinationName' must not be null");
        this.destination = destinationName;
    }

    protected String getDestinationName() {
        return this.destination instanceof String ? (String)this.destination : null;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    protected String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageListener(Object messageListener) {
        this.checkMessageListener(messageListener);
        this.messageListener = messageListener;
        if (this.durableSubscriptionName == null) {
            this.durableSubscriptionName = messageListener.getClass().getName();
        }
    }

    protected void checkMessageListener(Object messageListener) {
        if (!(messageListener instanceof MessageListener) && !(messageListener instanceof SessionAwareMessageListener)) {
            throw new IllegalArgumentException("messageListener needs to be of type [" + (class$javax$jms$MessageListener == null ? (class$javax$jms$MessageListener = AbstractMessageListenerContainer.class$("javax.jms.MessageListener")) : class$javax$jms$MessageListener).getName() + "] or [" + (class$org$springframework$jms$listener$SessionAwareMessageListener == null ? (class$org$springframework$jms$listener$SessionAwareMessageListener = AbstractMessageListenerContainer.class$("org.springframework.jms.listener.SessionAwareMessageListener")) : class$org$springframework$jms$listener$SessionAwareMessageListener).getName() + "]");
        }
    }

    protected Object getMessageListener() {
        return this.messageListener;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    protected boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        Assert.notNull(durableSubscriptionName, "'durableSubscriptionName' must not be null");
        this.durableSubscriptionName = durableSubscriptionName;
    }

    protected String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    protected boolean isExposeListenerSession() {
        return this.exposeListenerSession;
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    protected boolean isAcceptMessagesWhileStopping() {
        return this.acceptMessagesWhileStopping;
    }

    protected void validateConfiguration() {
        if (this.destination == null) {
            throw new IllegalArgumentException("Property 'destination' or 'destinationName' is required");
        }
        if (this.isSubscriptionDurable() && !this.isPubSubDomain()) {
            throw new IllegalArgumentException("A durable subscription requires a topic (pub-sub domain)");
        }
    }

    protected void executeListener(Session session, Message message) {
        try {
            this.doExecuteListener(session, message);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    protected void doExecuteListener(Session session, Message message) throws JMSException {
        if (!this.isAcceptMessagesWhileStopping() && !this.isRunning()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Rejecting received message because of the listener container having been stopped in the meantime: " + message));
            }
            this.rollbackIfNecessary(session);
            throw new MessageRejectedWhileStoppingException();
        }
        try {
            this.invokeListener(session, message);
        }
        catch (JMSException ex) {
            this.rollbackOnExceptionIfNecessary(session, ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.rollbackOnExceptionIfNecessary(session, ex);
            throw ex;
        }
        catch (Error err) {
            this.rollbackOnExceptionIfNecessary(session, err);
            throw err;
        }
        this.commitIfNecessary(session, message);
    }

    protected void invokeListener(Session session, Message message) throws JMSException {
        Object listener = this.getMessageListener();
        if (listener instanceof SessionAwareMessageListener) {
            this.doInvokeListener((SessionAwareMessageListener)listener, session, message);
        } else if (listener instanceof MessageListener) {
            this.doInvokeListener((MessageListener)listener, message);
        } else {
            if (listener != null) {
                throw new IllegalArgumentException("Only MessageListener and SessionAwareMessageListener supported: " + listener);
            }
            throw new IllegalStateException("No message listener specified - see property 'messageListener'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeListener(SessionAwareMessageListener listener, Session session, Message message) throws JMSException {
        Connection conToClose = null;
        Session sessionToClose = null;
        try {
            Session sessionToUse = session;
            if (!this.isExposeListenerSession()) {
                conToClose = this.createConnection();
                sessionToUse = sessionToClose = this.createSession(conToClose);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking listener with message of type [" + message.getClass() + "] and session [" + sessionToUse + "]"));
            }
            listener.onMessage(message, sessionToUse);
            if (sessionToUse != session && sessionToUse.getTransacted() && this.isSessionLocallyTransacted(sessionToUse)) {
                JmsUtils.commitIfNecessary(sessionToUse);
            }
        }
        catch (Throwable throwable) {
            JmsUtils.closeSession(sessionToClose);
            JmsUtils.closeConnection(conToClose);
            throw throwable;
        }
        JmsUtils.closeSession(sessionToClose);
        JmsUtils.closeConnection(conToClose);
    }

    protected void doInvokeListener(MessageListener listener, Message message) throws JMSException {
        listener.onMessage(message);
    }

    protected void commitIfNecessary(Session session, Message message) throws JMSException {
        if (session.getTransacted()) {
            if (this.isSessionLocallyTransacted(session)) {
                JmsUtils.commitIfNecessary(session);
            }
        } else if (this.isClientAcknowledge(session)) {
            message.acknowledge();
        }
    }

    protected void rollbackIfNecessary(Session session) throws JMSException {
        if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
            JmsUtils.rollbackIfNecessary(session);
        }
    }

    protected void rollbackOnExceptionIfNecessary(Session session, Throwable ex) throws JMSException {
        try {
            if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Initiating transaction rollback on application exception", ex);
                }
                JmsUtils.rollbackIfNecessary(session);
            }
        }
        catch (IllegalStateException ex2) {
            this.logger.debug((Object)"Could not roll back because Session already closed", (Throwable)ex2);
        }
        catch (JMSException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Application exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected boolean isSessionLocallyTransacted(Session session) {
        return this.isSessionTransacted();
    }

    protected void handleListenerException(Throwable ex) {
        if (ex instanceof MessageRejectedWhileStoppingException) {
            return;
        }
        if (ex instanceof JMSException) {
            this.invokeExceptionListener((JMSException)ex);
        }
        if (this.isActive()) {
            this.logger.warn((Object)"Execution of JMS message listener failed", ex);
        } else {
            this.logger.debug((Object)"Listener exception after container shutdown", ex);
        }
    }

    protected void invokeExceptionListener(JMSException ex) {
        ExceptionListener exceptionListener = this.getExceptionListener();
        if (exceptionListener != null) {
            exceptionListener.onException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MessageRejectedWhileStoppingException
    extends RuntimeException {
        private MessageRejectedWhileStoppingException() {
        }
    }
}

