/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PropertyValueException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.springframework.core.CollectionFactory;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateJdbcException;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate3.HibernateQueryException;
import org.springframework.orm.hibernate3.HibernateSystemException;
import org.springframework.orm.hibernate3.LocalDataSourceConnectionProvider;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.SpringSessionSynchronization;
import org.springframework.transaction.jta.SpringJtaSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class SessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$hibernate3$SessionFactoryUtils == null ? (class$org$springframework$orm$hibernate3$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.hibernate3.SessionFactoryUtils")) : class$org$springframework$orm$hibernate3$SessionFactoryUtils));
    private static final ThreadLocal deferredCloseHolder = new ThreadLocal();
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$SessionFactoryUtils;

    public static DataSource getDataSource(SessionFactory sessionFactory) {
        ConnectionProvider cp;
        if (sessionFactory instanceof SessionFactoryImplementor && (cp = ((SessionFactoryImplementor)sessionFactory).getConnectionProvider()) instanceof LocalDataSourceConnectionProvider) {
            return ((LocalDataSourceConnectionProvider)cp).getDataSource();
        }
        return null;
    }

    public static SQLExceptionTranslator newJdbcExceptionTranslator(SessionFactory sessionFactory) {
        DataSource ds = SessionFactoryUtils.getDataSource(sessionFactory);
        if (ds != null) {
            return new SQLErrorCodeSQLExceptionTranslator(ds);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    public static TransactionManager getJtaTransactionManager(SessionFactory sessionFactory, org.hibernate.Session session) {
        SessionFactory internalFactory;
        SessionFactoryImplementor sessionFactoryImpl = null;
        if (sessionFactory instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)sessionFactory;
        } else if (session != null && (internalFactory = session.getSessionFactory()) instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)internalFactory;
        }
        return sessionFactoryImpl != null ? sessionFactoryImpl.getTransactionManager() : null;
    }

    public static org.hibernate.Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, null, null, allowCreate);
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    public static org.hibernate.Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator) throws DataAccessResourceFailureException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, entityInterceptor, jdbcExceptionTranslator, true);
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    public static org.hibernate.Session doGetSession(SessionFactory sessionFactory, boolean allowCreate) throws HibernateException, IllegalStateException {
        return SessionFactoryUtils.doGetSession(sessionFactory, null, null, allowCreate);
    }

    private static org.hibernate.Session doGetSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator, boolean allowCreate) throws HibernateException, IllegalStateException {
        Session session;
        Assert.notNull(sessionFactory, "No SessionFactory specified");
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        if (sessionHolder != null && !sessionHolder.isEmpty()) {
            session = null;
            if (TransactionSynchronizationManager.isSynchronizationActive() && sessionHolder.doesNotHoldNonDefaultSession()) {
                session = sessionHolder.getValidatedSession();
                if (session != null && !sessionHolder.isSynchronizedWithTransaction()) {
                    logger.debug((Object)"Registering Spring transaction synchronization for existing Hibernate Session");
                    TransactionSynchronizationManager.registerSynchronization(new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                    FlushMode flushMode = session.getFlushMode();
                    if (flushMode.lessThan(FlushMode.COMMIT) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                        session.setFlushMode(FlushMode.AUTO);
                        sessionHolder.setPreviousFlushMode(flushMode);
                    }
                }
            } else {
                session = SessionFactoryUtils.getJtaSynchronizedSession(sessionHolder, sessionFactory, jdbcExceptionTranslator);
            }
            if (session != null) {
                return session;
            }
        }
        logger.debug((Object)"Opening Hibernate Session");
        Session session2 = session = entityInterceptor != null ? sessionFactory.openSession(entityInterceptor) : sessionFactory.openSession();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering Spring transaction synchronization for new Hibernate Session");
            SessionHolder holderToUse = sessionHolder;
            if (holderToUse == null) {
                holderToUse = new SessionHolder((org.hibernate.Session)session);
            } else {
                holderToUse.addSession((org.hibernate.Session)session);
            }
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setFlushMode(FlushMode.NEVER);
            }
            TransactionSynchronizationManager.registerSynchronization(new SpringSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != sessionHolder) {
                TransactionSynchronizationManager.bindResource(sessionFactory, holderToUse);
            }
        } else {
            SessionFactoryUtils.registerJtaSynchronization((org.hibernate.Session)session, sessionFactory, jdbcExceptionTranslator, sessionHolder);
        }
        if (!allowCreate && !SessionFactoryUtils.isSessionTransactional((org.hibernate.Session)session, sessionFactory)) {
            SessionFactoryUtils.closeSession((org.hibernate.Session)session);
            throw new IllegalStateException("No Hibernate Session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        return session;
    }

    private static org.hibernate.Session getJtaSynchronizedSession(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator) throws DataAccessResourceFailureException {
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (jtaTm != null) {
            try {
                int jtaStatus = jtaTm.getStatus();
                if (jtaStatus == 0 || jtaStatus == 1) {
                    Transaction jtaTx = jtaTm.getTransaction();
                    org.hibernate.Session session = sessionHolder.getValidatedSession(jtaTx);
                    if (session == null && !sessionHolder.isSynchronizedWithTransaction() && (session = sessionHolder.getValidatedSession()) != null) {
                        logger.debug((Object)"Registering JTA transaction synchronization for existing Hibernate Session");
                        sessionHolder.addSession(jtaTx, session);
                        jtaTx.registerSynchronization((Synchronization)new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false), jtaTm));
                        sessionHolder.setSynchronizedWithTransaction(true);
                        FlushMode flushMode = session.getFlushMode();
                        if (flushMode.lessThan(FlushMode.COMMIT)) {
                            session.setFlushMode(FlushMode.AUTO);
                            sessionHolder.setPreviousFlushMode(flushMode);
                        }
                    }
                    return session;
                }
                return sessionHolder.getValidatedSession();
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not check JTA transaction", ex);
            }
        }
        return sessionHolder.getValidatedSession();
    }

    private static void registerJtaSynchronization(org.hibernate.Session session, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, SessionHolder sessionHolder) {
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, session);
        if (jtaTm != null) {
            try {
                int jtaStatus = jtaTm.getStatus();
                if (jtaStatus == 0 || jtaStatus == 1) {
                    logger.debug((Object)"Registering JTA transaction synchronization for new Hibernate Session");
                    Transaction jtaTx = jtaTm.getTransaction();
                    SessionHolder holderToUse = sessionHolder;
                    if (holderToUse == null) {
                        holderToUse = new SessionHolder(jtaTx, session);
                    } else {
                        holderToUse.addSession(jtaTx, session);
                    }
                    jtaTx.registerSynchronization((Synchronization)new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true), jtaTm));
                    holderToUse.setSynchronizedWithTransaction(true);
                    if (holderToUse != sessionHolder) {
                        TransactionSynchronizationManager.bindResource(sessionFactory, holderToUse);
                    }
                }
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", ex);
            }
        }
    }

    public static org.hibernate.Session getNewSession(SessionFactory sessionFactory) {
        return SessionFactoryUtils.getNewSession(sessionFactory, null);
    }

    public static org.hibernate.Session getNewSession(SessionFactory sessionFactory, Interceptor entityInterceptor) {
        Assert.notNull(sessionFactory, "No SessionFactory specified");
        try {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
            if (sessionHolder != null && !sessionHolder.isEmpty()) {
                if (entityInterceptor != null) {
                    return sessionFactory.openSession(sessionHolder.getAnySession().connection(), entityInterceptor);
                }
                return sessionFactory.openSession(sessionHolder.getAnySession().connection());
            }
            if (entityInterceptor != null) {
                return sessionFactory.openSession(entityInterceptor);
            }
            return sessionFactory.openSession();
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    public static String toString(org.hibernate.Session session) {
        return session.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(session));
    }

    public static boolean isSessionTransactional(org.hibernate.Session session, SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        return sessionHolder != null && sessionHolder.containsSession(session);
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        SessionHolder sessionHolder;
        Assert.notNull(query, "No Query object specified");
        if (sessionFactory != null && (sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory)) != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static void applyTransactionTimeout(Criteria criteria, SessionFactory sessionFactory) {
        Assert.notNull(criteria, "No Criteria object specified");
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        if (sessionHolder != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), ex);
        }
        if (ex instanceof ConstraintViolationException) {
            return new DataIntegrityViolationException(ex.getMessage(), ex);
        }
        if (ex instanceof LockAcquisitionException) {
            return new CannotAcquireLockException(ex.getMessage(), ex);
        }
        if (ex instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof QueryException) {
            return new HibernateQueryException((QueryException)ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            return new HibernateObjectRetrievalFailureException((UnresolvableObjectException)ex);
        }
        if (ex instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1);
        }
        if (ex instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)ex);
        }
        if (ex instanceof StaleStateException) {
            return new HibernateOptimisticLockingFailureException((StaleStateException)ex);
        }
        return new HibernateSystemException(ex);
    }

    public static boolean isDeferredCloseActive(SessionFactory sessionFactory) {
        Assert.notNull(sessionFactory, "No SessionFactory specified");
        Map holderMap = (Map)deferredCloseHolder.get();
        return holderMap != null && holderMap.containsKey(sessionFactory);
    }

    public static void initDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull(sessionFactory, "No SessionFactory specified");
        logger.debug((Object)"Initializing deferred close of Hibernate Sessions");
        HashMap<SessionFactory, Set> holderMap = (HashMap<SessionFactory, Set>)deferredCloseHolder.get();
        if (holderMap == null) {
            holderMap = new HashMap<SessionFactory, Set>();
            deferredCloseHolder.set(holderMap);
        }
        holderMap.put(sessionFactory, CollectionFactory.createLinkedSetIfPossible(4));
    }

    public static void processDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull(sessionFactory, "No SessionFactory specified");
        Map holderMap = (Map)deferredCloseHolder.get();
        if (holderMap == null || !holderMap.containsKey(sessionFactory)) {
            throw new IllegalStateException("Deferred close not active for SessionFactory [" + sessionFactory + "]");
        }
        logger.debug((Object)"Processing deferred close of Hibernate Sessions");
        Set sessions = (Set)holderMap.remove(sessionFactory);
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            SessionFactoryUtils.closeSession((org.hibernate.Session)it.next());
        }
        if (holderMap.isEmpty()) {
            deferredCloseHolder.set(null);
        }
    }

    public static void releaseSession(org.hibernate.Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!SessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, sessionFactory);
        }
    }

    static void closeSessionOrRegisterDeferredClose(org.hibernate.Session session, SessionFactory sessionFactory) {
        Map holderMap = (Map)deferredCloseHolder.get();
        if (holderMap != null && sessionFactory != null && holderMap.containsKey(sessionFactory)) {
            logger.debug((Object)"Registering Hibernate Session for deferred close");
            session.setFlushMode(FlushMode.NEVER);
            Set sessions = (Set)holderMap.get(sessionFactory);
            sessions.add(session);
        } else {
            SessionFactoryUtils.closeSession(session);
        }
    }

    public static void closeSession(org.hibernate.Session session) {
        if (session != null) {
            logger.debug((Object)"Closing Hibernate Session");
            try {
                session.close();
            }
            catch (HibernateException ex) {
                logger.debug((Object)"Could not close Hibernate Session", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing Hibernate Session", ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

