/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.springframework.instrument.InstrumentationSavingAgent;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class InstrumentationLoadTimeWeaver
implements LoadTimeWeaver {
    private final ClassLoader classLoader;
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>(4);

    public InstrumentationLoadTimeWeaver() {
        this.classLoader = ClassUtils.getDefaultClassLoader();
    }

    public InstrumentationLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        FilteringClassFileTransformer actualTransformer = new FilteringClassFileTransformer(transformer, this.classLoader);
        this.getInstrumentation().addTransformer(actualTransformer);
        this.transformers.add(actualTransformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }

    public void removeTransformers() {
        Instrumentation instrumentation = this.getInstrumentation();
        for (int i = this.transformers.size() - 1; i >= 0; --i) {
            instrumentation.removeTransformer(this.transformers.get(i));
        }
        this.transformers.clear();
    }

    private Instrumentation getInstrumentation() {
        Instrumentation instrumentation = InstrumentationSavingAgent.getInstrumentation();
        if (instrumentation == null) {
            throw new IllegalStateException("Must start with Java agent to use InstrumentationLoadTimeWeaver. See Spring documentation.");
        }
        return instrumentation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringClassFileTransformer
    implements ClassFileTransformer {
        private final ClassFileTransformer targetTransformer;
        private final ClassLoader targetClassLoader;

        public FilteringClassFileTransformer(ClassFileTransformer targetTransformer, ClassLoader targetClassLoader) {
            this.targetTransformer = targetTransformer;
            this.targetClassLoader = targetClassLoader;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (!this.targetClassLoader.equals(loader)) {
                return null;
            }
            return this.targetTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }

        public String toString() {
            return "FilteringClassFileTransformer for: " + this.targetTransformer.toString();
        }
    }
}

