/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync;

import java.util.List;
import org.springframework.sync.PatchException;
import org.springframework.sync.PatchOperation;
import org.springframework.sync.util.DeepCloneUtils;

public class Patch {
    private final List<PatchOperation> operations;

    public Patch(List<PatchOperation> operations) {
        this.operations = operations;
    }

    public int size() {
        return this.operations.size();
    }

    public List<PatchOperation> getOperations() {
        return this.operations;
    }

    public <T> T apply(T in, Class<T> type) throws PatchException {
        T work = DeepCloneUtils.deepClone(in);
        for (PatchOperation operation : this.operations) {
            operation.perform(work, type);
        }
        return work;
    }

    public <T> List<T> apply(List<T> in, Class<T> type) throws PatchException {
        List<T> work = DeepCloneUtils.deepClone(in);
        for (PatchOperation operation : this.operations) {
            operation.perform(work, type);
        }
        return work;
    }
}

