/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync;

import java.util.Arrays;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class PathToSpEL {
    private static final SpelExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();

    public static Expression pathToExpression(String path) {
        return SPEL_EXPRESSION_PARSER.parseExpression(PathToSpEL.pathToSpEL(path));
    }

    public static Expression spelToExpression(String spel) {
        return SPEL_EXPRESSION_PARSER.parseExpression(spel);
    }

    public static Expression pathToParentExpression(String path) {
        return PathToSpEL.spelToExpression(PathToSpEL.pathNodesToSpEL(Arrays.copyOf(path.split("\\/"), path.split("\\/").length - 1)));
    }

    private static String pathToSpEL(String path) {
        return PathToSpEL.pathNodesToSpEL(path.split("\\/"));
    }

    private static String pathNodesToSpEL(String[] pathNodes) {
        StringBuilder spelBuilder = new StringBuilder();
        for (int i = 0; i < pathNodes.length; ++i) {
            String pathNode = pathNodes[i];
            if (pathNode.length() == 0) continue;
            if ("~".equals(pathNode)) {
                spelBuilder.append("[size() - 1]");
                continue;
            }
            try {
                int index = Integer.parseInt(pathNode);
                spelBuilder.append('[').append(index).append(']');
                continue;
            }
            catch (NumberFormatException e) {
                if (spelBuilder.length() > 0) {
                    spelBuilder.append('.');
                }
                spelBuilder.append(pathNode);
            }
        }
        String spel = spelBuilder.toString();
        if (spel.length() == 0) {
            spel = "#this";
        }
        return spel;
    }
}

