/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.diffsync;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.sync.diffsync.AbstractShadowStore;

public class GemfireShadowStore
extends AbstractShadowStore
implements DisposableBean {
    private GemfireOperations gemfireTemplate;
    private List<String> keys = new ArrayList<String>();

    public GemfireShadowStore(String remoteNodeId, GemfireOperations gemfireTemplate) {
        super(remoteNodeId);
        this.gemfireTemplate = gemfireTemplate;
    }

    @Override
    public void putShadow(String key, Object shadow) {
        String nodeKey = this.getNodeSpecificKey(key);
        this.gemfireTemplate.put((Object)nodeKey, shadow);
        this.keys.add(nodeKey);
    }

    @Override
    public Object getShadow(String key) {
        return this.gemfireTemplate.get((Object)this.getNodeSpecificKey(key));
    }

    public void destroy() throws Exception {
        for (String key : this.keys) {
            this.gemfireTemplate.remove((Object)key);
        }
    }
}

