/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.sync.AddOperation;
import org.springframework.sync.CopyOperation;
import org.springframework.sync.FromOperation;
import org.springframework.sync.MoveOperation;
import org.springframework.sync.Patch;
import org.springframework.sync.PatchException;
import org.springframework.sync.PatchOperation;
import org.springframework.sync.RemoveOperation;
import org.springframework.sync.ReplaceOperation;
import org.springframework.sync.TestOperation;
import org.springframework.sync.json.JsonLateObjectEvaluator;

public class JsonPatchMaker {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Patch fromJsonNode(JsonNode jsonNode) {
        if (!(jsonNode instanceof ArrayNode)) {
            throw new IllegalArgumentException("JsonNode must be an instance of ArrayNode");
        }
        ArrayNode opNodes = (ArrayNode)jsonNode;
        ArrayList<PatchOperation> ops = new ArrayList<PatchOperation>(opNodes.size());
        Iterator elements = opNodes.elements();
        while (elements.hasNext()) {
            String from;
            JsonNode opNode = (JsonNode)elements.next();
            String opType = opNode.get("op").textValue();
            String path = opNode.get("path").textValue();
            JsonNode valueNode = opNode.get("value");
            Object value = this.valueFromJsonNode(path, valueNode);
            String string = from = opNode.has("from") ? opNode.get("from").textValue() : null;
            if (opType.equals("test")) {
                ops.add(new TestOperation(path, value));
                continue;
            }
            if (opType.equals("replace")) {
                ops.add(new ReplaceOperation(path, value));
                continue;
            }
            if (opType.equals("remove")) {
                ops.add(new RemoveOperation(path));
                continue;
            }
            if (opType.equals("add")) {
                ops.add(new AddOperation(path, value));
                continue;
            }
            if (opType.equals("copy")) {
                ops.add(new CopyOperation(path, from));
                continue;
            }
            if (opType.equals("move")) {
                ops.add(new MoveOperation(path, from));
                continue;
            }
            throw new PatchException("Unrecognized operation type: " + opType);
        }
        return new Patch(ops);
    }

    public JsonNode toJsonNode(Patch patch) {
        List<PatchOperation> operations = patch.getOperations();
        JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
        ArrayNode patchNode = nodeFactory.arrayNode();
        for (PatchOperation operation : operations) {
            Object value;
            ObjectNode opNode = nodeFactory.objectNode();
            opNode.set("op", (JsonNode)nodeFactory.textNode(operation.getOp()));
            opNode.set("path", (JsonNode)nodeFactory.textNode(operation.getPath()));
            if (operation instanceof FromOperation) {
                FromOperation fromOp = (FromOperation)operation;
                opNode.set("from", (JsonNode)nodeFactory.textNode(fromOp.getFrom()));
            }
            if ((value = operation.getValue()) != null) {
                opNode.set("value", MAPPER.valueToTree(value));
            }
            patchNode.add((JsonNode)opNode);
        }
        return patchNode;
    }

    private Object valueFromJsonNode(String path, JsonNode valueNode) {
        if (valueNode == null || valueNode.isNull()) {
            return null;
        }
        if (valueNode.isTextual()) {
            return valueNode.asText();
        }
        if (valueNode.isFloatingPointNumber()) {
            return valueNode.asDouble();
        }
        if (valueNode.isBoolean()) {
            return valueNode.asBoolean();
        }
        if (valueNode.isInt()) {
            return valueNode.asInt();
        }
        if (valueNode.isLong()) {
            return valueNode.asLong();
        }
        if (valueNode.isObject()) {
            return new JsonLateObjectEvaluator(valueNode);
        }
        if (valueNode.isArray()) {
            // empty if block
        }
        return null;
    }
}

