/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.Assert;

final class MockWebResponseBuilder {
    private final long startTime;
    private final WebRequest webRequest;
    private final MockHttpServletResponse response;

    public MockWebResponseBuilder(long startTime, WebRequest webRequest, MockHttpServletResponse httpServletResponse) {
        Assert.notNull((Object)webRequest, (String)"webRequest");
        Assert.notNull((Object)httpServletResponse, (String)"httpServletResponse cannot be null");
        this.startTime = startTime;
        this.webRequest = webRequest;
        this.response = httpServletResponse;
    }

    public WebResponse build() throws IOException {
        WebResponseData webResponseData = this.webResponseData();
        long endTime = System.currentTimeMillis();
        return new WebResponse(webResponseData, this.webRequest, endTime - this.startTime);
    }

    private WebResponseData webResponseData() throws IOException {
        List<NameValuePair> responseHeaders = this.responseHeaders();
        int statusCode = this.response.getRedirectedUrl() == null ? this.response.getStatus() : 301;
        String statusMessage = this.statusMessage(statusCode);
        return new WebResponseData(this.response.getContentAsByteArray(), statusCode, statusMessage, responseHeaders);
    }

    private String statusMessage(int statusCode) {
        String errorMessage = this.response.getErrorMessage();
        if (errorMessage != null) {
            return errorMessage;
        }
        try {
            return HttpStatus.valueOf((int)statusCode).getReasonPhrase();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "N/A";
        }
    }

    private List<NameValuePair> responseHeaders() {
        Collection headerNames = this.response.getHeaderNames();
        ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>(headerNames.size());
        for (String headerName : headerNames) {
            List headerValues = this.response.getHeaderValues(headerName);
            for (Object value : headerValues) {
                responseHeaders.add(new NameValuePair(headerName, String.valueOf(value)));
            }
        }
        String location = this.response.getRedirectedUrl();
        if (location != null) {
            responseHeaders.add(new NameValuePair("Location", location));
        }
        return responseHeaders;
    }
}

