/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ExpressionVariable;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.support.CompositeStringExpression;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.binding.expression.support.NullParserContext;
import org.springframework.util.Assert;

public abstract class AbstractExpressionParser
implements ExpressionParser {
    private static final String DEFAULT_EXPRESSION_PREFIX = "${";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "}";
    private String expressionPrefix = "${";
    private String expressionSuffix = "}";
    private boolean allowDelimitedEvalExpressions;

    public String getExpressionPrefix() {
        return this.expressionPrefix;
    }

    public void setExpressionPrefix(String expressionPrefix) {
        this.expressionPrefix = expressionPrefix;
    }

    public String getExpressionSuffix() {
        return this.expressionSuffix;
    }

    public void setExpressionSuffix(String expressionSuffix) {
        this.expressionSuffix = expressionSuffix;
    }

    public boolean getAllowDelimitedEvalExpressions() {
        return this.allowDelimitedEvalExpressions;
    }

    public void setAllowDelimitedEvalExpressions(boolean allowDelmitedEvalExpressions) {
        this.allowDelimitedEvalExpressions = allowDelmitedEvalExpressions;
    }

    @Override
    public Expression parseExpression(String expressionString, ParserContext context) throws ParserException {
        Assert.notNull((Object)expressionString, (String)"The expression string to parse is required");
        if (context == null) {
            context = NullParserContext.INSTANCE;
        }
        if (context.isTemplate()) {
            return this.parseTemplate(expressionString, context);
        }
        if (expressionString.startsWith(this.getExpressionPrefix()) && expressionString.endsWith(this.getExpressionSuffix())) {
            if (!this.allowDelimitedEvalExpressions) {
                throw new ParserException(expressionString, "The expression '" + expressionString + "' being parsed is expected be an expression. Do not enclose such expression strings in ${} delimiters as it's redundant. If you need to parse a template that mixes literal text with evaluatable blocks, set the 'template' parser context attribute to true.", null);
            }
            int lastIndex = expressionString.length() - this.getExpressionSuffix().length();
            String expression = expressionString.substring(this.getExpressionPrefix().length(), lastIndex);
            return this.doParseExpression(expression, context);
        }
        return this.doParseExpression(expressionString, context);
    }

    private Expression parseTemplate(String expressionString, ParserContext context) throws ParserException {
        Assert.notNull((Object)expressionString, (String)"The expression string to parse is required");
        if (expressionString.length() == 0) {
            return this.parseEmptyExpressionString(context);
        }
        Expression[] expressions = this.parseExpressions(expressionString, context);
        if (expressions.length == 1) {
            return expressions[0];
        }
        return new CompositeStringExpression(expressions);
    }

    private Expression parseEmptyExpressionString(ParserContext context) {
        if (this.allowDelimitedEvalExpressions) {
            return this.doParseExpression("", context);
        }
        return new LiteralExpression("");
    }

    private Expression[] parseExpressions(String expressionString, ParserContext context) throws ParserException {
        LinkedList<Expression> expressions = new LinkedList<Expression>();
        int startIdx = 0;
        while (startIdx < expressionString.length()) {
            int prefixIndex = expressionString.indexOf(this.getExpressionPrefix(), startIdx);
            if (prefixIndex >= startIdx) {
                int nextPrefixIndex;
                int suffixIndex;
                if (prefixIndex > startIdx) {
                    expressions.add(new LiteralExpression(expressionString.substring(startIdx, prefixIndex)));
                    startIdx = prefixIndex;
                }
                if ((suffixIndex = (nextPrefixIndex = expressionString.indexOf(this.getExpressionPrefix(), prefixIndex + this.getExpressionPrefix().length())) == -1 ? expressionString.lastIndexOf(this.getExpressionSuffix()) : expressionString.lastIndexOf(this.getExpressionSuffix(), nextPrefixIndex)) < prefixIndex + this.getExpressionPrefix().length()) {
                    throw new ParserException(expressionString, "No ending suffix '" + this.getExpressionSuffix() + "' for expression starting at character " + prefixIndex + ": " + expressionString.substring(prefixIndex), null);
                }
                if (suffixIndex == prefixIndex + this.getExpressionPrefix().length()) {
                    throw new ParserException(expressionString, "No expression defined within delimiter '" + this.getExpressionPrefix() + this.getExpressionSuffix() + "' at character " + prefixIndex, null);
                }
                String expr = expressionString.substring(prefixIndex + this.getExpressionPrefix().length(), suffixIndex);
                expressions.add(this.doParseExpression(expr, context));
                startIdx = suffixIndex + 1;
                continue;
            }
            if (startIdx == 0) {
                if (this.allowDelimitedEvalExpressions) {
                    expressions.add(this.doParseExpression(expressionString, context));
                } else {
                    expressions.add(new LiteralExpression(expressionString));
                }
            } else {
                expressions.add(new LiteralExpression(expressionString.substring(startIdx)));
            }
            startIdx = expressionString.length();
        }
        return expressions.toArray(new Expression[expressions.size()]);
    }

    protected Map<String, Expression> parseVariableExpressions(ExpressionVariable[] variables) throws ParserException {
        if (variables == null || variables.length == 0) {
            return null;
        }
        HashMap<String, Expression> variableExpressions = new HashMap<String, Expression>(variables.length, 1.0f);
        for (ExpressionVariable var : variables) {
            variableExpressions.put(var.getName(), this.parseExpression(var.getValueExpression(), var.getParserContext()));
        }
        return variableExpressions;
    }

    protected abstract Expression doParseExpression(String var1, ParserContext var2) throws ParserException;
}

