/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.ArrayList;
import javax.faces.component.ActionSource;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.validation.ValidationHelper;
import org.springframework.webflow.validation.WebFlowMessageCodesResolver;

public class FlowActionListener
implements ActionListener {
    private static final Log logger = LogFactory.getLog(FlowActionListener.class);
    private static final String MESSAGES_ID = "messages";
    private ActionListener delegate;
    private MessageCodesResolver messageCodesResolver = new WebFlowMessageCodesResolver();

    public FlowActionListener(ActionListener delegate) {
        this.delegate = delegate;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (!JsfUtils.isFlowRequest()) {
            this.delegate.processAction(actionEvent);
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ActionSource source = (ActionSource)actionEvent.getSource();
        String eventId = null;
        if (source.getAction() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking action " + source.getAction()));
            }
            eventId = (String)source.getAction().invoke(context, null);
        }
        if (StringUtils.hasText(eventId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event '" + eventId + "' detected"));
            }
            if (source.isImmediate() || this.validateModel(context, eventId)) {
                context.getExternalContext().getRequestMap().put("org.springframework.webflow.FacesEvent", eventId);
            }
        } else {
            logger.debug((Object)"No action event detected");
            context.getExternalContext().getRequestMap().remove("org.springframework.webflow.FacesEvent");
        }
        context.renderResponse();
    }

    private boolean validateModel(FacesContext facesContext, String eventId) {
        Object model;
        boolean isValid = true;
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        if (this.shouldValidate(requestContext, model = this.getModelObject(requestContext), eventId)) {
            this.validate(requestContext, model, eventId);
            if (requestContext.getMessageContext().hasErrorMessages()) {
                isValid = false;
                if (requestContext.getExternalContext().isAjaxRequest()) {
                    ArrayList<String> fragments = new ArrayList<String>();
                    String formId = this.getModelExpression(requestContext).getExpressionString();
                    if (facesContext.getViewRoot().findComponent(formId) != null) {
                        fragments.add(formId);
                    }
                    if (facesContext.getViewRoot().findComponent(MESSAGES_ID) != null) {
                        fragments.add(MESSAGES_ID);
                    }
                    if (fragments.size() > 0) {
                        String[] fragmentsArray = new String[fragments.size()];
                        for (int i = 0; i < fragments.size(); ++i) {
                            fragmentsArray[i] = (String)fragments.get(i);
                        }
                        requestContext.getFlashScope().put("flowRenderFragments", (Object)fragmentsArray);
                    }
                }
            }
        }
        return isValid;
    }

    private Object getModelObject(RequestContext requestContext) {
        Expression model = this.getModelExpression(requestContext);
        if (model != null) {
            return model.getValue((Object)requestContext);
        }
        return null;
    }

    private Expression getModelExpression(RequestContext requestContext) {
        return (Expression)requestContext.getCurrentState().getAttributes().get("model");
    }

    private boolean shouldValidate(RequestContext requestContext, Object model, String eventId) {
        if (model == null) {
            return false;
        }
        TransitionDefinition transition = requestContext.getMatchingTransition(eventId);
        if (transition != null && transition.getAttributes().contains("validate")) {
            return transition.getAttributes().getBoolean("validate");
        }
        return true;
    }

    private void validate(RequestContext requestContext, Object model, String eventId) {
        new ValidationHelper(model, requestContext, eventId, this.getModelExpression(requestContext).getExpressionString(), null, this.messageCodesResolver, null).validate();
    }
}

