/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class SpringBeanWebFlowVariableResolver
extends VariableResolver {
    private static final BeanFactory EMPTY_BEAN_FACTORY = new StaticListableBeanFactory();
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final VariableResolver originalVariableResolver;

    public SpringBeanWebFlowVariableResolver(VariableResolver originalVariableResolver) {
        Assert.notNull((Object)originalVariableResolver, (String)"Original JSF VariableResolver must not be null");
        this.originalVariableResolver = originalVariableResolver;
    }

    protected final VariableResolver getOriginalVariableResolver() {
        return this.originalVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        Object bean = this.resolveSpringBean(facesContext, name);
        if (bean != null) {
            return bean;
        }
        Object value = this.resolveOriginal(facesContext, name);
        if (value != null) {
            return value;
        }
        return null;
    }

    protected Object resolveOriginal(FacesContext facesContext, String name) {
        Object value = this.getOriginalVariableResolver().resolveVariable(facesContext, name);
        if (value != null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Successfully resolved variable '" + name + "' via original VariableResolver"));
        }
        return value;
    }

    protected Object resolveSpringBean(FacesContext facesContext, String name) {
        BeanFactory bf = this.getBeanFactory(facesContext);
        if (bf.containsBean(name)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Successfully resolved variable '" + name + "' in Spring BeanFactory"));
            }
            return bf.getBean(name);
        }
        return null;
    }

    protected BeanFactory getBeanFactory(FacesContext facesContext) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        if (requestContext == null) {
            return EMPTY_BEAN_FACTORY;
        }
        ApplicationContext beanFactory = requestContext.getActiveFlow().getApplicationContext();
        return beanFactory != null ? beanFactory : EMPTY_BEAN_FACTORY;
    }
}

