/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.w3c.dom.Element;

public class ResourcesBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String SERVLET_RESOURCE_HANDLER_BEAN_NAME = "jsfResourceRequestHandler";
    private static final boolean isRichFacesPresent = ClassUtils.isPresent((String)"org.richfaces.application.CoreConfiguration", (ClassLoader)ResourcesBeanDefinitionParser.class.getClassLoader());

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        this.registerHandlerAdapterIfNecessary(source, parserContext);
        this.registerResourceHandler(source, parserContext);
        this.registerHandlerMappings(element, source, parserContext);
        return null;
    }

    private void registerHandlerAdapterIfNecessary(Object source, ParserContext parserContext) {
        String beanName = "org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter";
        if (parserContext.getRegistry().containsBeanDefinition(beanName)) {
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(HttpRequestHandlerAdapter.class);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDefinition);
    }

    private void registerResourceHandler(Object source, ParserContext parserContext) {
        String beanName = "org.springframework.faces.webflow.JsfResourceRequestHandler";
        RootBeanDefinition beanDefinition = new RootBeanDefinition(beanName);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        parserContext.getRegistry().registerBeanDefinition(SERVLET_RESOURCE_HANDLER_BEAN_NAME, (BeanDefinition)beanDefinition);
    }

    private void registerHandlerMappings(Element element, Object source, ParserContext parserContext) {
        ManagedMap urlMap = new ManagedMap();
        urlMap.put("/javax.faces.resource/**", SERVLET_RESOURCE_HANDLER_BEAN_NAME);
        if (isRichFacesPresent) {
            urlMap.put("/rfRes/**", SERVLET_RESOURCE_HANDLER_BEAN_NAME);
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        beanDefinition.getPropertyValues().add("urlMap", (Object)urlMap);
        String order = element.getAttribute("order");
        beanDefinition.getPropertyValues().add("order", StringUtils.hasText((String)order) ? order : Integer.valueOf(0));
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDefinition);
    }
}

