/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.oxm.GenericMarshaller;
import org.springframework.oxm.GenericUnmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jaxb.AbstractJaxbMarshaller;
import org.springframework.oxm.jaxb.JaxbUnmarshallingFailureException;
import org.springframework.oxm.jaxb.JaxbUtils;
import org.springframework.oxm.mime.MimeContainer;
import org.springframework.oxm.mime.MimeMarshaller;
import org.springframework.oxm.mime.MimeUnmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.TraxUtils;
import org.springframework.xml.validation.SchemaLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaxb2Marshaller
extends AbstractJaxbMarshaller
implements MimeMarshaller,
MimeUnmarshaller,
GenericMarshaller,
GenericUnmarshaller,
BeanClassLoaderAware {
    private ClassLoader classLoader;
    private Resource[] schemaResources;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Marshaller.Listener marshallerListener;
    private Unmarshaller.Listener unmarshallerListener;
    private XmlAdapter[] adapters;
    private Schema schema;
    private Class[] classesToBeBound;
    private Map<String, ?> jaxbContextProperties;
    private boolean mtomEnabled = false;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setAdapters(XmlAdapter[] adapters) {
        this.adapters = adapters;
    }

    public void setClassesToBeBound(Class[] classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
    }

    public void setJaxbContextProperties(Map<String, ?> jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public void setSchema(Resource schemaResource) {
        this.schemaResources = new Resource[]{schemaResource};
    }

    public void setSchemas(Resource[] schemaResources) {
        this.schemaResources = schemaResources;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    @Override
    public boolean supports(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return this.supportsInternal((Class)type, true);
        }
        if (type instanceof ParameterizedType && JAXBElement.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) {
            Assert.isTrue((parameterizedType.getActualTypeArguments().length == 1 ? 1 : 0) != 0, (String)"Invalid amount of parameterized types in JAXBElement");
            Type typeArgument = parameterizedType.getActualTypeArguments()[0];
            if (typeArgument instanceof Class) {
                Class clazz = (Class)typeArgument;
                if (!(this.isPrimitiveType(clazz) || this.isStandardType(clazz) || this.supportsInternal(clazz, false))) {
                    return false;
                }
            } else {
                if (typeArgument instanceof GenericArrayType) {
                    GenericArrayType genericArrayType = (GenericArrayType)typeArgument;
                    return genericArrayType.getGenericComponentType().equals(Byte.TYPE);
                }
                if (!this.supports(typeArgument)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isPrimitiveType(Class clazz) {
        return Boolean.class.equals((Object)clazz) || Byte.class.equals((Object)clazz) || Short.class.equals((Object)clazz) || Integer.class.equals((Object)clazz) || Long.class.equals((Object)clazz) || Float.class.equals((Object)clazz) || Double.class.equals((Object)clazz) || byte[].class.equals((Object)clazz);
    }

    private boolean isStandardType(Class clazz) {
        return String.class.equals((Object)clazz) || BigInteger.class.equals((Object)clazz) || BigDecimal.class.equals((Object)clazz) || Calendar.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || QName.class.equals((Object)clazz) || URI.class.equals((Object)clazz) || XMLGregorianCalendar.class.isAssignableFrom(clazz) || Duration.class.isAssignableFrom(clazz) || Object.class.equals((Object)clazz) || Image.class.isAssignableFrom(clazz) || DataHandler.class.equals((Object)clazz) || Source.class.isAssignableFrom(clazz) || UUID.class.equals((Object)clazz);
    }

    public boolean supports(Class clazz) {
        return this.supportsInternal(clazz, true);
    }

    private boolean supportsInternal(Class<?> clazz, boolean checkForXmlRootElement) {
        if (checkForXmlRootElement && clazz.getAnnotation(XmlRootElement.class) == null) {
            return false;
        }
        if (clazz.getAnnotation(XmlType.class) == null) {
            return false;
        }
        if (StringUtils.hasLength((String)this.getContextPath())) {
            String className = ClassUtils.getQualifiedName(clazz);
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return false;
            }
            String packageName = className.substring(0, lastDotIndex);
            String[] contextPaths = StringUtils.tokenizeToStringArray((String)this.getContextPath(), (String)":");
            for (int i = 0; i < contextPaths.length; ++i) {
                if (!contextPaths[i].equals(packageName)) continue;
                return true;
            }
            return false;
        }
        if (!ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
            return Arrays.asList(this.classesToBeBound).contains(clazz);
        }
        return false;
    }

    protected JAXBContext createJaxbContext() throws Exception {
        if (JaxbUtils.getJaxbVersion() < 1) {
            throw new IllegalStateException("Cannot use Jaxb2Marshaller in combination with JAXB 1.0. Use Jaxb1Marshaller instead.");
        }
        if (StringUtils.hasLength((String)this.getContextPath()) && !ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
            throw new IllegalArgumentException("specify either contextPath or classesToBeBound property; not both");
        }
        if (!ObjectUtils.isEmpty((Object[])this.schemaResources)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting validation schema to " + StringUtils.arrayToCommaDelimitedString((Object[])this.schemaResources)));
            }
            this.schema = SchemaLoaderUtils.loadSchema((Resource[])this.schemaResources, (String)this.schemaLanguage);
        }
        if (StringUtils.hasLength((String)this.getContextPath())) {
            return this.createJaxbContextFromContextPath();
        }
        if (!ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
            return this.createJaxbContextFromClasses();
        }
        throw new IllegalArgumentException("setting either contextPath or classesToBeBound is required");
    }

    private JAXBContext createJaxbContextFromContextPath() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext with context path [" + this.getContextPath() + "]"));
        }
        if (this.jaxbContextProperties != null) {
            if (this.classLoader != null) {
                return JAXBContext.newInstance((String)this.getContextPath(), (ClassLoader)this.classLoader, this.jaxbContextProperties);
            }
            return JAXBContext.newInstance((String)this.getContextPath(), (ClassLoader)ClassUtils.getDefaultClassLoader(), this.jaxbContextProperties);
        }
        return this.classLoader != null ? JAXBContext.newInstance((String)this.getContextPath(), (ClassLoader)this.classLoader) : JAXBContext.newInstance((String)this.getContextPath());
    }

    private JAXBContext createJaxbContextFromClasses() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext with classes to be bound [" + StringUtils.arrayToCommaDelimitedString((Object[])this.classesToBeBound) + "]"));
        }
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((Class[])this.classesToBeBound, this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((Class[])this.classesToBeBound);
    }

    protected void initJaxbMarshaller(Marshaller marshaller) throws JAXBException {
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
        if (this.marshallerListener != null) {
            marshaller.setListener(this.marshallerListener);
        }
        if (this.adapters != null) {
            for (int i = 0; i < this.adapters.length; ++i) {
                marshaller.setAdapter(this.adapters[i]);
            }
        }
    }

    protected void initJaxbUnmarshaller(Unmarshaller unmarshaller) throws JAXBException {
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        if (this.unmarshallerListener != null) {
            unmarshaller.setListener(this.unmarshallerListener);
        }
        if (this.adapters != null) {
            for (int i = 0; i < this.adapters.length; ++i) {
                unmarshaller.setAdapter(this.adapters[i]);
            }
        }
    }

    public void marshal(Object graph, Result result) throws XmlMappingException {
        this.marshal(graph, result, null);
    }

    public void marshal(Object graph, Result result, MimeContainer mimeContainer) throws XmlMappingException {
        try {
            Marshaller marshaller = this.createMarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                marshaller.setAttachmentMarshaller((AttachmentMarshaller)new Jaxb2AttachmentMarshaller(mimeContainer));
            }
            if (TraxUtils.isStaxResult((Result)result)) {
                this.marshalStaxResult(marshaller, graph, result);
            } else {
                marshaller.marshal(graph, result);
            }
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    private void marshalStaxResult(Marshaller jaxbMarshaller, Object graph, Result staxResult) throws JAXBException {
        XMLStreamWriter streamWriter = TraxUtils.getXMLStreamWriter((Result)staxResult);
        if (streamWriter != null) {
            jaxbMarshaller.marshal(graph, streamWriter);
        } else {
            XMLEventWriter eventWriter = TraxUtils.getXMLEventWriter((Result)staxResult);
            if (eventWriter != null) {
                jaxbMarshaller.marshal(graph, eventWriter);
            } else {
                throw new IllegalArgumentException("StAX Result contains neither XMLStreamWriter nor XMLEventConsumer");
            }
        }
    }

    public Object unmarshal(Source source) throws XmlMappingException {
        return this.unmarshal(source, null);
    }

    public Object unmarshal(Source source, MimeContainer mimeContainer) throws XmlMappingException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new Jaxb2AttachmentUnmarshaller(mimeContainer));
            }
            if (TraxUtils.isStaxSource((Source)source)) {
                return this.unmarshalStaxSource(unmarshaller, source);
            }
            return unmarshaller.unmarshal(source);
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    private Object unmarshalStaxSource(Unmarshaller jaxbUnmarshaller, Source staxSource) throws JAXBException {
        XMLStreamReader streamReader = TraxUtils.getXMLStreamReader((Source)staxSource);
        if (streamReader != null) {
            return jaxbUnmarshaller.unmarshal(streamReader);
        }
        XMLEventReader eventReader = TraxUtils.getXMLEventReader((Source)staxSource);
        if (eventReader != null) {
            return jaxbUnmarshaller.unmarshal(eventReader);
        }
        throw new IllegalArgumentException("StaxSource contains neither XMLStreamReader nor XMLEventReader");
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private byte[] data;
        private String contentType;
        private int offset;
        private int length;

        public ByteArrayDataSource(String contentType, byte[] data, int offset, int length) {
            this.contentType = contentType;
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data, this.offset, this.length);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return "ByteArrayDataSource";
        }
    }

    private static class Jaxb2AttachmentUnmarshaller
    extends AttachmentUnmarshaller {
        private final MimeContainer mimeContainer;

        public Jaxb2AttachmentUnmarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public byte[] getAttachmentAsByteArray(String cid) {
            try {
                DataHandler dataHandler = this.getAttachmentAsDataHandler(cid);
                return FileCopyUtils.copyToByteArray((InputStream)dataHandler.getInputStream());
            }
            catch (IOException ex) {
                throw new JaxbUnmarshallingFailureException(ex);
            }
        }

        public DataHandler getAttachmentAsDataHandler(String contentId) {
            if (contentId.startsWith("cid:")) {
                contentId = contentId.substring("cid:".length());
                try {
                    contentId = URLDecoder.decode(contentId, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                contentId = '<' + contentId + '>';
            }
            return this.mimeContainer.getAttachment(contentId);
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.isXopPackage();
        }
    }

    private static class Jaxb2AttachmentMarshaller
    extends AttachmentMarshaller {
        private final MimeContainer mimeContainer;

        public Jaxb2AttachmentMarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(mimeType, data, offset, length);
            return this.addMtomAttachment(new DataHandler((DataSource)dataSource), elementNamespace, elementLocalName);
        }

        public String addMtomAttachment(DataHandler dataHandler, String elementNamespace, String elementLocalName) {
            String host = this.getHost(elementNamespace, dataHandler);
            String contentId = UUID.randomUUID() + "@" + host;
            this.mimeContainer.addAttachment("<" + contentId + ">", dataHandler);
            try {
                contentId = URLEncoder.encode(contentId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return "cid:" + contentId;
        }

        private String getHost(String elementNamespace, DataHandler dataHandler) {
            try {
                URI uri = new URI(elementNamespace);
                return uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                return dataHandler.getName();
            }
        }

        public String addSwaRefAttachment(DataHandler dataHandler) {
            String contentId = UUID.randomUUID() + "@" + dataHandler.getName();
            this.mimeContainer.addAttachment(contentId, dataHandler);
            return contentId;
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.convertToXopPackage();
        }
    }
}

