/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class KeyStoreFactoryBean
implements FactoryBean,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$ws$soap$security$support$KeyStoreFactoryBean == null ? (class$org$springframework$ws$soap$security$support$KeyStoreFactoryBean = KeyStoreFactoryBean.class$("org.springframework.ws.soap.security.support.KeyStoreFactoryBean")) : class$org$springframework$ws$soap$security$support$KeyStoreFactoryBean));
    private KeyStore keyStore;
    private String type;
    private String provider;
    private Resource location;
    private char[] password;
    static /* synthetic */ Class class$org$springframework$ws$soap$security$support$KeyStoreFactoryBean;
    static /* synthetic */ Class class$java$security$KeyStore;

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setPassword(String password) {
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getObject() throws Exception {
        return this.keyStore;
    }

    public Class getObjectType() {
        return class$java$security$KeyStore == null ? (class$java$security$KeyStore = KeyStoreFactoryBean.class$("java.security.KeyStore")) : class$java$security$KeyStore;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterPropertiesSet() throws GeneralSecurityException, IOException {
        this.keyStore = StringUtils.hasLength((String)this.provider) && StringUtils.hasLength((String)this.type) ? KeyStore.getInstance(this.type, this.provider) : (StringUtils.hasLength((String)this.type) ? KeyStore.getInstance(this.type) : KeyStore.getInstance(KeyStore.getDefaultType()));
        InputStream is = null;
        try {
            if (this.location != null && this.location.exists()) {
                is = this.location.getInputStream();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Loading key store from " + this.location));
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)"Creating empty key store");
            }
            this.keyStore.load(is, this.password);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

