/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyManagersFactoryBean
implements FactoryBean<KeyManager[]>,
InitializingBean {
    private KeyManagerFactory keyManagerFactory;
    private KeyStore keyStore;
    private String algorithm;
    private String provider;
    private char[] password;

    public void setPassword(String password) {
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyManager[] getObject() throws Exception {
        return this.keyManagerFactory.getKeyManagers();
    }

    public Class<?> getObjectType() {
        return KeyManager[].class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        String algorithm = StringUtils.hasLength((String)this.algorithm) ? this.algorithm : KeyManagerFactory.getDefaultAlgorithm();
        this.keyManagerFactory = StringUtils.hasLength((String)this.provider) ? KeyManagerFactory.getInstance(algorithm, this.provider) : KeyManagerFactory.getInstance(algorithm);
        this.keyManagerFactory.init(this.keyStore, this.password);
    }
}

