/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.xmpp.MessageInputStream;
import org.springframework.ws.transport.xmpp.MessageOutputStream;
import org.springframework.ws.transport.xmpp.support.XmppTransportUtils;

public class XmppSenderConnection
extends AbstractSenderConnection {
    private final Message requestMessage;
    private final XMPPConnection connection;
    private Message responseMessage;
    private String messageEncoding;
    private long receiveTimeout;

    protected XmppSenderConnection(XMPPConnection connection, String to, String thread) {
        Assert.notNull((Object)connection, (String)"'connection' must not be null");
        Assert.hasLength((String)to, (String)"'to' must not be empty");
        Assert.hasLength((String)thread, (String)"'thread' must not be empty");
        this.connection = connection;
        this.requestMessage = new Message(to, Message.Type.chat);
        this.requestMessage.setThread(thread);
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setMessageEncoding(String messageEncoding) {
        this.messageEncoding = messageEncoding;
    }

    void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public URI getUri() throws URISyntaxException {
        return XmppTransportUtils.toUri(this.requestMessage);
    }

    public boolean hasError() {
        return XmppTransportUtils.hasError(this.responseMessage);
    }

    public String getErrorMessage() {
        return XmppTransportUtils.getErrorMessage(this.responseMessage);
    }

    public void addRequestHeader(String name, String value) {
        XmppTransportUtils.addHeader(this.requestMessage, name, value);
    }

    protected OutputStream getRequestOutputStream() throws IOException {
        return new MessageOutputStream(this.requestMessage, this.messageEncoding);
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.requestMessage.setFrom(this.connection.getUser());
        try {
            this.connection.sendStanza((Stanza)this.requestMessage);
        }
        catch (SmackException.NotConnectedException e) {
            throw new IOException(e);
        }
    }

    protected void onReceiveBeforeRead() throws IOException {
        Stanza packet;
        StanzaFilter packetFilter = this.createPacketFilter();
        PacketCollector collector = this.connection.createPacketCollector(packetFilter);
        Stanza stanza = packet = this.receiveTimeout >= 0L ? collector.nextResult(this.receiveTimeout) : collector.nextResult();
        if (packet instanceof Message) {
            this.responseMessage = (Message)packet;
        } else if (packet != null) {
            throw new IllegalArgumentException("Wrong packet type: [" + packet.getClass() + "]. Only Messages can be handled.");
        }
    }

    private StanzaFilter createPacketFilter() {
        AndFilter andFilter = new AndFilter();
        andFilter.addFilter((StanzaFilter)new StanzaTypeFilter(Message.class));
        andFilter.addFilter((StanzaFilter)new ThreadFilter(this.requestMessage.getThread()));
        return andFilter;
    }

    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    public Iterator<String> getResponseHeaderNames() {
        return XmppTransportUtils.getHeaderNames(this.responseMessage);
    }

    public Iterator<String> getResponseHeaders(String name) throws IOException {
        return XmppTransportUtils.getHeaders(this.responseMessage, name);
    }

    protected InputStream getResponseInputStream() throws IOException {
        return new MessageInputStream(this.responseMessage, this.messageEncoding);
    }
}

