/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import java.io.IOException;
import java.io.OutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.springframework.util.Assert;
import org.springframework.ws.transport.jms.JmsTransportException;

class BytesMessageOutputStream
extends OutputStream {
    private final BytesMessage message;

    BytesMessageOutputStream(BytesMessage message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        this.message = message;
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.message.writeBytes(b);
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.message.writeBytes(b, off, len);
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.message.writeByte((byte)b);
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
    }
}

