/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.client;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import javax.xml.transform.Source;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.test.client.ErrorResponseCreator;
import org.springframework.ws.test.client.ExceptionResponseCreator;
import org.springframework.ws.test.client.ResponseCreator;
import org.springframework.ws.test.client.SoapFaultResponseCreator;
import org.springframework.ws.test.support.creator.PayloadMessageCreator;
import org.springframework.ws.test.support.creator.WebServiceMessageCreator;
import org.springframework.xml.transform.ResourceSource;

public abstract class ResponseCreators {
    private ResponseCreators() {
    }

    public static ResponseCreator withPayload(Source payload) {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        return new WebServiceMessageCreatorAdapter(new PayloadMessageCreator(payload));
    }

    public static ResponseCreator withPayload(Resource payload) throws IOException {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        return ResponseCreators.withPayload((Source)new ResourceSource(payload));
    }

    public static ResponseCreator withError(String errorMessage) {
        Assert.hasLength((String)errorMessage, (String)"'errorMessage' must not be empty");
        return new ErrorResponseCreator(errorMessage);
    }

    public static ResponseCreator withException(IOException ioException) {
        Assert.notNull((Object)ioException, (String)"'ioException' must not be null");
        return new ExceptionResponseCreator(ioException);
    }

    public static ResponseCreator withException(RuntimeException ex) {
        Assert.notNull((Object)ex, (String)"'ex' must not be null");
        return new ExceptionResponseCreator(ex);
    }

    public static ResponseCreator withMustUnderstandFault(final String faultStringOrReason, final Locale locale) {
        Assert.hasLength((String)faultStringOrReason, (String)"'faultStringOrReason' must not be empty");
        return new SoapFaultResponseCreator(){

            public void addSoapFault(SoapBody soapBody) {
                soapBody.addMustUnderstandFault(faultStringOrReason, locale);
            }
        };
    }

    public static ResponseCreator withClientOrSenderFault(final String faultStringOrReason, final Locale locale) {
        Assert.hasLength((String)faultStringOrReason, (String)"'faultStringOrReason' must not be empty");
        return new SoapFaultResponseCreator(){

            public void addSoapFault(SoapBody soapBody) {
                soapBody.addClientOrSenderFault(faultStringOrReason, locale);
            }
        };
    }

    public static ResponseCreator withServerOrReceiverFault(final String faultStringOrReason, final Locale locale) {
        Assert.hasLength((String)faultStringOrReason, (String)"'faultStringOrReason' must not be empty");
        return new SoapFaultResponseCreator(){

            public void addSoapFault(SoapBody soapBody) {
                soapBody.addServerOrReceiverFault(faultStringOrReason, locale);
            }
        };
    }

    public static ResponseCreator withVersionMismatchFault(final String faultStringOrReason, final Locale locale) {
        Assert.hasLength((String)faultStringOrReason, (String)"'faultStringOrReason' must not be empty");
        return new SoapFaultResponseCreator(){

            public void addSoapFault(SoapBody soapBody) {
                soapBody.addVersionMismatchFault(faultStringOrReason, locale);
            }
        };
    }

    private static class WebServiceMessageCreatorAdapter
    implements ResponseCreator {
        private final WebServiceMessageCreator adaptee;

        private WebServiceMessageCreatorAdapter(WebServiceMessageCreator adaptee) {
            this.adaptee = adaptee;
        }

        public WebServiceMessage createResponse(URI uri, WebServiceMessage request, WebServiceMessageFactory messageFactory) throws IOException {
            return this.adaptee.createMessage(messageFactory);
        }
    }
}

