/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support.matcher;

import java.io.IOException;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.matcher.WebServiceMessageMatcher;
import org.springframework.xml.transform.TransformerHelper;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExpectationsHelper {
    private final XPathExpression expression;
    private final String expressionString;
    private final TransformerHelper transformerHelper = new TransformerHelper();

    public XPathExpectationsHelper(String expression) {
        this(expression, null);
    }

    public XPathExpectationsHelper(String expression, Map<String, String> namespaces) {
        Assert.hasLength((String)expression, (String)"'expression' must not be empty");
        this.expression = XPathExpressionFactory.createXPathExpression((String)expression, namespaces);
        this.expressionString = expression;
    }

    public WebServiceMessageMatcher exists() {
        return new WebServiceMessageMatcher(){

            public void match(WebServiceMessage message) throws IOException, AssertionError {
                Node payload = XPathExpectationsHelper.this.transformToNode(message);
                Node result = XPathExpectationsHelper.this.expression.evaluateAsNode(payload);
                if (result == null) {
                    AssertionErrors.fail("No match for \"" + XPathExpectationsHelper.this.expressionString + "\" found", "Payload", message.getPayloadSource());
                }
            }
        };
    }

    public WebServiceMessageMatcher doesNotExist() {
        return new WebServiceMessageMatcher(){

            public void match(WebServiceMessage message) throws IOException, AssertionError {
                Node payload = XPathExpectationsHelper.this.transformToNode(message);
                Node result = XPathExpectationsHelper.this.expression.evaluateAsNode(payload);
                if (result != null) {
                    AssertionErrors.fail("Match for \"" + XPathExpectationsHelper.this.expressionString + "\" found", "Payload", message.getPayloadSource());
                }
            }
        };
    }

    public WebServiceMessageMatcher evaluatesTo(final boolean expectedValue) {
        return new WebServiceMessageMatcher(){

            public void match(WebServiceMessage message) throws IOException, AssertionError {
                Node payload = XPathExpectationsHelper.this.transformToNode(message);
                boolean result = XPathExpectationsHelper.this.expression.evaluateAsBoolean(payload);
                AssertionErrors.assertEquals("Evaluation of XPath expression \"" + XPathExpectationsHelper.this.expressionString + "\" failed.", expectedValue, result, "Payload", message.getPayloadSource());
            }
        };
    }

    public WebServiceMessageMatcher evaluatesTo(int expectedValue) {
        return this.evaluatesTo((double)expectedValue);
    }

    public WebServiceMessageMatcher evaluatesTo(final double expectedValue) {
        return new WebServiceMessageMatcher(){

            public void match(WebServiceMessage message) throws IOException, AssertionError {
                Node payload = XPathExpectationsHelper.this.transformToNode(message);
                double result = XPathExpectationsHelper.this.expression.evaluateAsNumber(payload);
                AssertionErrors.assertEquals("Evaluation of XPath expression \"" + XPathExpectationsHelper.this.expressionString + "\" failed.", expectedValue, result, "Payload", message.getPayloadSource());
            }
        };
    }

    public WebServiceMessageMatcher evaluatesTo(final String expectedValue) {
        Assert.notNull((Object)expectedValue, (String)"'expectedValue' must not be null");
        return new WebServiceMessageMatcher(){

            public void match(WebServiceMessage message) throws IOException, AssertionError {
                Node payload = XPathExpectationsHelper.this.transformToNode(message);
                String result = XPathExpectationsHelper.this.expression.evaluateAsString(payload);
                AssertionErrors.assertEquals("Evaluation of XPath expression \"" + XPathExpectationsHelper.this.expressionString + "\" failed.", expectedValue, result, "Payload", message.getPayloadSource());
            }
        };
    }

    private Node transformToNode(WebServiceMessage request) {
        DOMResult domResult = new DOMResult();
        try {
            this.transformerHelper.transform(request.getPayloadSource(), (Result)domResult);
            return domResult.getNode();
        }
        catch (TransformerException ex) {
            AssertionErrors.fail("Could not transform request payload: " + ex.getMessage());
            return null;
        }
    }
}

