/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MockStrategiesHelper {
    private static final Log logger = LogFactory.getLog(MockStrategiesHelper.class);
    private final ApplicationContext applicationContext;

    public MockStrategiesHelper(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public <T> T getStrategy(Class<T> type) {
        Assert.notNull(type, (String)"'type' must not be null");
        Map map = this.applicationContext.getBeansOfType(type);
        if (map.isEmpty()) {
            return null;
        }
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using " + ClassUtils.getShortName(type) + " [" + (String)entry.getKey() + "]"));
            }
            return (T)entry.getValue();
        }
        throw new BeanInitializationException("Could not find exactly 1 " + ClassUtils.getShortName(type) + " in application context");
    }

    public <T, D extends T> T getStrategy(Class<T> type, Class<D> defaultType) {
        Object defaultStrategy;
        Assert.notNull(defaultType, (String)"'defaultType' must not be null");
        T t = this.getStrategy(type);
        if (t != null) {
            return t;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No " + ClassUtils.getShortName(type) + " found, using default " + ClassUtils.getShortName(defaultType)));
        }
        if ((defaultStrategy = BeanUtils.instantiateClass(defaultType)) instanceof ApplicationContextAware) {
            ApplicationContextAware applicationContextAware = (ApplicationContextAware)defaultStrategy;
            applicationContextAware.setApplicationContext(this.applicationContext);
        }
        if (defaultStrategy instanceof InitializingBean) {
            InitializingBean initializingBean = (InitializingBean)defaultStrategy;
            try {
                initializingBean.afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanCreationException("Invocation of init method failed", (Throwable)ex);
            }
        }
        return (T)defaultStrategy;
    }
}

