/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.client;

import java.io.IOException;
import java.net.URI;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.test.client.AbstractResponseCreator;
import org.springframework.ws.test.support.AssertionErrors;

abstract class SoapFaultResponseCreator
extends AbstractResponseCreator {
    SoapFaultResponseCreator() {
    }

    @Override
    protected void doWithResponse(URI uri, WebServiceMessage request, WebServiceMessage response) throws IOException {
        if (!(response instanceof SoapMessage)) {
            AssertionErrors.fail("Response is not a SOAP message");
            return;
        }
        SoapMessage soapResponse = (SoapMessage)response;
        SoapBody responseBody = soapResponse.getSoapBody();
        if (responseBody == null) {
            AssertionErrors.fail("SOAP message [" + response + "] does not contain SOAP body");
        }
        this.addSoapFault(responseBody);
    }

    protected abstract void addSoapFault(SoapBody var1);
}

