/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.stream;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.springframework.xml.stream.AbstractStaxXmlReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public class StaxStreamXmlReader
extends AbstractStaxXmlReader {
    private final XMLStreamReader reader;
    private final SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();

    public StaxStreamXmlReader(XMLStreamReader reader) {
        int event = reader.getEventType();
        if (event != 7 && event != 1) {
            throw new IllegalStateException("XMLEventReader not at start of document or element");
        }
        this.reader = reader;
    }

    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean documentStarted = false;
        boolean documentEnded = false;
        int elementDepth = 0;
        int eventType = this.reader.getEventType();
        while (true) {
            if (eventType != 7 && eventType != 8 && !documentStarted) {
                this.handleStartDocument();
                documentStarted = true;
            }
            switch (eventType) {
                case 1: {
                    ++elementDepth;
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    if (--elementDepth < 0) break;
                    this.handleEndElement();
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters();
                    break;
                }
                case 7: {
                    this.setLocator(this.reader.getLocation());
                    this.handleStartDocument();
                    documentStarted = true;
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    documentEnded = true;
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 11: {
                    this.handleDtd();
                    break;
                }
                case 9: {
                    this.handleEntityReference();
                }
            }
            if (!this.reader.hasNext() || elementDepth < 0) break;
            eventType = this.reader.next();
        }
        if (!documentEnded) {
            this.handleEndDocument();
        }
    }

    private void handleStartDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().startDocument();
            if (this.reader.standaloneSet()) {
                this.setStandalone(this.reader.isStandalone());
            }
        }
    }

    private void handleStartElement() throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            if (this.hasNamespacesFeature()) {
                String prefix;
                int i;
                for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
                    prefix = this.reader.getNamespacePrefix(i);
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.startPrefixMapping(prefix, this.reader.getNamespaceURI(i));
                }
                for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                    String namespace;
                    prefix = this.reader.getAttributePrefix(i);
                    if (prefix == null) {
                        prefix = "";
                    }
                    if ((namespace = this.reader.getAttributeNamespace(i)) == null) continue;
                    this.startPrefixMapping(prefix, namespace);
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), QNameUtils.toQualifiedName(qName), this.getAttributes());
            } else {
                this.getContentHandler().startElement("", "", QNameUtils.toQualifiedName(qName), this.getAttributes());
            }
        }
    }

    private void startPrefixMapping(String prefix, String namespace) throws SAXException {
        if (!this.namespaceContext.getNamespaceURI(prefix).equals(namespace)) {
            this.getContentHandler().startPrefixMapping(prefix, namespace);
            this.namespaceContext.bindNamespaceUri(prefix, namespace);
        }
    }

    private void handleEndElement() throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            if (this.hasNamespacesFeature()) {
                this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), QNameUtils.toQualifiedName(qName));
                for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
                    String prefix = this.reader.getNamespacePrefix(i);
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.endPrefixMapping(prefix);
                }
            } else {
                this.getContentHandler().endElement("", "", QNameUtils.toQualifiedName(qName));
            }
        }
    }

    private void endPrefixMapping(String prefix) throws SAXException {
        if (this.namespaceContext.hasBinding(prefix)) {
            this.getContentHandler().endPrefixMapping(prefix);
            this.namespaceContext.removeBinding(prefix);
        }
    }

    private void handleCharacters() throws SAXException {
        if (this.getContentHandler() != null && this.reader.isWhiteSpace()) {
            this.getContentHandler().ignorableWhitespace(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            return;
        }
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().startCDATA();
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().endCDATA();
        }
    }

    private void handleComment() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().comment(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
    }

    private void handleDtd() throws SAXException {
        if (this.getLexicalHandler() != null) {
            Location location = this.reader.getLocation();
            this.getLexicalHandler().startDTD(null, location.getPublicId(), location.getSystemId());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endDTD();
        }
    }

    private void handleEntityReference() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().startEntity(this.reader.getLocalName());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endEntity(this.reader.getLocalName());
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleProcessingInstruction() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(this.reader.getPITarget(), this.reader.getPIData());
        }
    }

    private Attributes getAttributes() {
        int i;
        AttributesImpl attributes = new AttributesImpl();
        for (i = 0; i < this.reader.getAttributeCount(); ++i) {
            String type;
            String namespace = this.reader.getAttributeNamespace(i);
            if (namespace == null || !this.hasNamespacesFeature()) {
                namespace = "";
            }
            if ((type = this.reader.getAttributeType(i)) == null) {
                type = "CDATA";
            }
            attributes.addAttribute(namespace, this.reader.getAttributeLocalName(i), QNameUtils.toQualifiedName(this.reader.getAttributeName(i)), type, this.reader.getAttributeValue(i));
        }
        if (this.hasNamespacePrefixesFeature()) {
            for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
                String prefix = this.reader.getNamespacePrefix(i);
                String namespaceUri = this.reader.getNamespaceURI(i);
                String qName = StringUtils.hasLength((String)prefix) ? "xmlns:" + prefix : "xmlns";
                attributes.addAttribute("", "", qName, "CDATA", namespaceUri);
            }
        }
        return attributes;
    }
}

