/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.common.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReflectionUtils {
    private static Pattern fieldNamePattern = Pattern.compile("[g|s]et(.)(.*)");

    public static Field getFirstAnnotatedField(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Field match = null;
        if (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                match = field;
                break;
            }
            if (match == null) {
                match = ReflectionUtils.getFirstAnnotatedField(clazz.getSuperclass(), annotationClass);
            }
        }
        return match;
    }

    public static List<Field> getAllAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        LinkedList<Field> fields = new LinkedList<Field>();
        if (clazz != null) {
            fields.addAll(ReflectionUtils.getAllAnnotatedFields(clazz.getSuperclass(), annotationClass));
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static Method getFirstAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Method match = null;
        if (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                match = method;
                break;
            }
            if (match == null) {
                match = ReflectionUtils.getFirstAnnotatedMethod(clazz.getSuperclass(), annotationClass);
            }
        }
        return match;
    }

    public static Class<?> getFirstAnnotatedClass(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Class<?> annotatedClass;
        if (clazz == null) {
            return null;
        }
        Class<Object> clazz2 = annotatedClass = clazz.isAnnotationPresent(annotationClass) ? clazz : null;
        if (annotatedClass == null) {
            annotatedClass = ReflectionUtils.getFirstAnnotatedClass(clazz.getSuperclass(), annotationClass);
        }
        return annotatedClass;
    }

    public static <T extends Annotation> T getFirstClassAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (clazz == null) {
            return null;
        }
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ReflectionUtils.getFirstClassAnnotation(clazz.getSuperclass(), annotationClass);
        }
        return annotation;
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        if (clazz == null) {
            return false;
        }
        boolean annotationPresent = clazz.isAnnotationPresent(annotationClass);
        if (!annotationPresent) {
            annotationPresent = ReflectionUtils.isAnnotationPresent(clazz.getSuperclass(), annotationClass);
        }
        return annotationPresent;
    }

    public static boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    public static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static String toFieldName(Method getterOrSetter) {
        Matcher matcher = fieldNamePattern.matcher(getterOrSetter.getName());
        return matcher.matches() ? matcher.group(1).toLowerCase() + matcher.group(2) : null;
    }

    public static Field getReferencedField(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Method method;
        Field field = ReflectionUtils.getFirstAnnotatedField(clazz, annotationClass);
        if (field == null && (method = ReflectionUtils.getFirstAnnotatedMethod(clazz, annotationClass)) != null && (ReflectionUtils.isGetter(method) || ReflectionUtils.isSetter(method))) {
            String fieldName = ReflectionUtils.toFieldName(method);
            try {
                field = fieldName != null ? clazz.getDeclaredField(fieldName) : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (field == null) {
                try {
                    field = fieldName != null ? clazz.getField(fieldName) : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return field;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        for (Class<?> current = clazz; current != null && field == null; current = current.getSuperclass()) {
            try {
                field = current.getDeclaredField(fieldName);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }
}

